/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.io;

import com.soywiz.korio.net.http.HttpClient;
import com.soywiz.korio.util.checksum.CRC32;
import com.soywiz.korio.util.checksum.SimpleChecksum;
import com.soywiz.korio.util.checksum.SimpleChecksumKt;
import com.soywiz.krypto.Hash;
import com.soywiz.krypto.SHA256;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.iriscan.sdk.core.PlatformContext;
import net.iriscan.sdk.core.io.HashMethod;
import net.iriscan.sdk.io.ResourceIO;
import net.iriscan.sdk.io.exception.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J0\u0010\u001b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J0\u0010\u001c\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/iriscan/sdk/io/ResourceIOImpl;", "Lnet/iriscan/sdk/io/ResourceIO;", "context", "Lnet/iriscan/sdk/core/PlatformContext;", "(Lnet/iriscan/sdk/core/PlatformContext;)V", "client", "Lcom/soywiz/korio/net/http/HttpClient;", "cacheDelete", "", "name", "", "cacheExists", "cacheLoad", "", "cacheSave", "", "data", "calculateHash", "method", "Lnet/iriscan/sdk/core/io/HashMethod;", "read", "path", "readOrCache", "Lnet/iriscan/sdk/io/ResourceIOImpl$CachedData;", "modelCheckSum", "modelChecksumMethod", "overrideOnWrongChecksum", "readOrCacheLoadData", "readOrCacheLoadPath", "CachedData", "biometric-sdk"})
public final class ResourceIOImpl
implements ResourceIO {
    @NotNull
    private final PlatformContext context;
    @NotNull
    private final HttpClient client;

    public ResourceIOImpl(@NotNull PlatformContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.client = HttpClient.Companion.invoke();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public byte[] read(@NotNull String path) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"classpath:", (boolean)false, (int)2, null)) {
            byte[] byArray2;
            InputStream inputStream = this.getClass().getResourceAsStream(StringsKt.replace$default((String)path, (String)"classpath:", (String)"", (boolean)false, (int)4, null));
            if (inputStream == null || (byArray2 = ByteStreamsKt.readBytes((InputStream)inputStream)) == null) throw new IOException("File " + path + " not found", null, 2, null);
            byArray = byArray2;
            return byArray;
        }
        if (StringsKt.startsWith$default((String)path, (String)"file:", (boolean)false, (int)2, null)) {
            byte[] byArray3;
            try {
                byArray3 = FilesKt.readBytes((File)new File(StringsKt.replace$default((String)path, (String)"file:", (String)"", (boolean)false, (int)4, null)));
            }
            catch (java.io.IOException e) {
                throw new IOException("Could not read file at path: " + path, e);
            }
            byArray = byArray3;
            return byArray;
        }
        if (!StringsKt.startsWith$default((String)path, (String)"https:", (boolean)false, (int)2, null)) throw new IOException("Illegal path: " + path, null, 2, null);
        byArray = (byte[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, path, null){
            int label;
            final /* synthetic */ ResourceIOImpl this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpClient.readBytes$default((HttpClient)ResourceIOImpl.access$getClient$p(this.this$0), (String)this.$path, null, (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return byArray;
    }

    @Override
    @NotNull
    public String calculateHash(@NotNull byte[] data2, @NotNull HashMethod method) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                String string2 = Integer.toString(SimpleChecksumKt.compute$default((SimpleChecksum)((SimpleChecksum)CRC32.INSTANCE), (byte[])data2, (int)0, (int)0, (int)6, null), CharsKt.checkRadix((int)16));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                break;
            }
            case 2: {
                string = Hash.getHexLower-impl((byte[])SHA256.Companion.digest-R6UBAiE(data2));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    public boolean cacheExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path cachePath = new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/" + name).toPath();
        return Files.exists(cachePath, new LinkOption[0]);
    }

    @Override
    public void cacheSave(@NotNull String name, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Path cachePath = new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/" + name).toPath();
        Path path = Files.createFile(cachePath, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createFile(cachePath)");
        Path path2 = path;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(path2, data2, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    @Override
    @NotNull
    public byte[] cacheLoad(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path cachePath = new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/" + name).toPath();
        byte[] byArray = Files.readAllBytes(cachePath);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(cachePath)");
        return byArray;
    }

    @Override
    public boolean cacheDelete(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path cachePath = new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/" + name).toPath();
        return Files.deleteIfExists(cachePath);
    }

    @Override
    @NotNull
    public byte[] readOrCacheLoadData(@NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.readOrCache(name, path).getData();
    }

    @Override
    @NotNull
    public byte[] readOrCacheLoadData(@NotNull String name, @NotNull String path, @NotNull String modelCheckSum, @NotNull HashMethod modelChecksumMethod, boolean overrideOnWrongChecksum) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modelCheckSum, (String)"modelCheckSum");
        Intrinsics.checkNotNullParameter((Object)((Object)modelChecksumMethod), (String)"modelChecksumMethod");
        return this.readOrCache(name, path).getData();
    }

    @Override
    @NotNull
    public String readOrCacheLoadPath(@NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.readOrCache(name, path).getUrl();
    }

    @Override
    @NotNull
    public String readOrCacheLoadPath(@NotNull String name, @NotNull String path, @NotNull String modelCheckSum, @NotNull HashMethod modelChecksumMethod, boolean overrideOnWrongChecksum) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modelCheckSum, (String)"modelCheckSum");
        Intrinsics.checkNotNullParameter((Object)((Object)modelChecksumMethod), (String)"modelChecksumMethod");
        return this.readOrCache(name, path, modelCheckSum, modelChecksumMethod, overrideOnWrongChecksum).getUrl();
    }

    private final CachedData readOrCache(String name, String path) {
        CachedData cachedData;
        if (this.cacheExists(name)) {
            cachedData = new CachedData(name, this.cacheLoad(name));
        } else {
            byte[] data2 = this.read(path);
            this.cacheSave(name, data2);
            cachedData = new CachedData(name, data2);
        }
        return cachedData;
    }

    private final CachedData readOrCache(String name, String path, String modelCheckSum, HashMethod modelChecksumMethod, boolean overrideOnWrongChecksum) {
        CachedData cachedData;
        boolean modelExists = this.cacheExists(name);
        byte[] data2 = this.readOrCacheLoadData(name, path);
        String checkSum = this.calculateHash(data2, modelChecksumMethod);
        if (!modelExists || overrideOnWrongChecksum && !Intrinsics.areEqual((Object)checkSum, (Object)modelCheckSum)) {
            byte[] newData;
            String newDataChecksum;
            if (modelExists) {
                this.cacheDelete(name);
            }
            if (!Intrinsics.areEqual((Object)(newDataChecksum = this.calculateHash(newData = this.read(path), modelChecksumMethod)), (Object)modelCheckSum)) {
                throw new IOException("Invalid " + path + " checksum, expected: " + newDataChecksum + ", provided: " + modelCheckSum, null, 2, null);
            }
            this.cacheSave(name, newData);
            cachedData = new CachedData(name, newData);
        } else {
            cachedData = new CachedData(name, data2);
        }
        return cachedData;
    }

    public static final /* synthetic */ HttpClient access$getClient$p(ResourceIOImpl $this) {
        return $this.client;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/iriscan/sdk/io/ResourceIOImpl$CachedData;", "", "url", "", "data", "", "(Ljava/lang/String;[B)V", "getData", "()[B", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "biometric-sdk"})
    private static final class CachedData {
        @NotNull
        private final String url;
        @NotNull
        private final byte[] data;

        public CachedData(@NotNull String url, @NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.url = url;
            this.data = data2;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final byte[] component2() {
            return this.data;
        }

        @NotNull
        public final CachedData copy(@NotNull String url, @NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return new CachedData(url, data2);
        }

        public static /* synthetic */ CachedData copy$default(CachedData cachedData, String string, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = cachedData.url;
            }
            if ((n & 2) != 0) {
                byArray = cachedData.data;
            }
            return cachedData.copy(string, byArray);
        }

        @NotNull
        public String toString() {
            return "CachedData(url=" + this.url + ", data=" + Arrays.toString(this.data) + ")";
        }

        public int hashCode() {
            int result2 = this.url.hashCode();
            result2 = result2 * 31 + Arrays.hashCode(this.data);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedData)) {
                return false;
            }
            CachedData cachedData = (CachedData)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cachedData.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)cachedData.data);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HashMethod.values().length];
            try {
                nArray[HashMethod.CRC32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HashMethod.SHA256.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

