/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.face.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.image.ColorKt;
import net.iriscan.sdk.core.utils.ImageUtilsKt;
import net.iriscan.sdk.face.FaceNetModelConfiguration;
import net.iriscan.sdk.tf.InterpreterImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0007\u001a\u00060\bj\u0002`\u000b2\n\u0010\t\u001a\u00060\fj\u0002`\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JP\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001326\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0016H\u0002J(\u0010\u001c\u001a\u00060\fj\u0002`\r2\n\u0010\u001d\u001a\u00060\fj\u0002`\r2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\f\u0010 \u001a\u00020\b*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/iriscan/sdk/face/impl/FaceEncoderInternal;", "", "faceNetModelConfig", "Lnet/iriscan/sdk/face/FaceNetModelConfiguration;", "(Lnet/iriscan/sdk/face/FaceNetModelConfiguration;)V", "interpreter", "Lnet/iriscan/sdk/tf/InterpreterImpl;", "encode", "", "image", "Lnet/iriscan/sdk/core/image/Image;", "Lnet/iriscan/sdk/core/io/DataBytes;", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "encodeInternal", "data", "", "normalize", "width", "", "height", "getColor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "x", "y", "Ljava/awt/Color;", "resizeNative", "originalImage", "targetWidth", "targetHeight", "toByteArray", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nFaceEncoderInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaceEncoderInternal.kt\nnet/iriscan/sdk/face/impl/FaceEncoderInternal\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,80:1\n10242#2:81\n10664#2,5:82\n*S KotlinDebug\n*F\n+ 1 FaceEncoderInternal.kt\nnet/iriscan/sdk/face/impl/FaceEncoderInternal\n*L\n53#1:81\n53#1:82,5\n*E\n"})
public final class FaceEncoderInternal {
    @NotNull
    private final FaceNetModelConfiguration faceNetModelConfig;
    @NotNull
    private final InterpreterImpl interpreter;

    public FaceEncoderInternal(@NotNull FaceNetModelConfiguration faceNetModelConfig) {
        Intrinsics.checkNotNullParameter((Object)faceNetModelConfig, (String)"faceNetModelConfig");
        this.faceNetModelConfig = faceNetModelConfig;
        this.interpreter = new InterpreterImpl("facenet.tflite", this.faceNetModelConfig.getPath(), this.faceNetModelConfig.getModelChecksum(), this.faceNetModelConfig.getModelChecksumMethod(), this.faceNetModelConfig.getOverrideCacheOnWrongChecksum());
    }

    @NotNull
    public final byte[] encode(@NotNull net.iriscan.sdk.core.image.Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        net.iriscan.sdk.core.image.Image resized = ImageUtilsKt.resizeImg(image, this.faceNetModelConfig.getInputWidth(), this.faceNetModelConfig.getInputHeight());
        float[] data2 = this.normalize(resized.getWidth(), resized.getHeight(), (Function2<? super Integer, ? super Integer, ? extends Color>)((Function2)new Function2<Integer, Integer, Color>(resized){
            final /* synthetic */ net.iriscan.sdk.core.image.Image $resized;
            {
                this.$resized = $resized;
                super(2);
            }

            @NotNull
            public final Color invoke(int x, int y) {
                int color = this.$resized.get(x, y);
                return new Color(ColorKt.red(color), ColorKt.green(color), ColorKt.blue(color));
            }
        }));
        return this.encodeInternal(data2);
    }

    @NotNull
    public final byte[] encode(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage resized = this.resizeNative(image, this.faceNetModelConfig.getInputWidth(), this.faceNetModelConfig.getInputHeight());
        float[] data2 = this.normalize(resized.getWidth(), resized.getHeight(), (Function2<? super Integer, ? super Integer, ? extends Color>)((Function2)new Function2<Integer, Integer, Color>(resized){
            final /* synthetic */ BufferedImage $resized;
            {
                this.$resized = $resized;
                super(2);
            }

            @NotNull
            public final Color invoke(int x, int y) {
                return new Color(this.$resized.getRGB(x, y));
            }
        }));
        return this.encodeInternal(data2);
    }

    /*
     * WARNING - void declaration
     */
    private final float[] normalize(int width, int height, Function2<? super Integer, ? super Integer, ? extends Color> getColor) {
        void $this$flatMapTo$iv$iv;
        Object color;
        int n = 0;
        int n2 = width * height;
        float[][] fArrayArray = new float[n2][];
        while (n < n2) {
            int n3 = n++;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
            fArrayArray[n3] = fArray;
        }
        float[][] rgb = fArrayArray;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = (Color)getColor.invoke((Object)x, (Object)y);
                int i = y * width + x;
                rgb[i][0] = ((float)((Color)color).getRed() - 127.5f) / 128.0f;
                rgb[i][1] = ((float)((Color)color).getGreen() - 127.5f) / 128.0f;
                rgb[i][2] = ((float)((Color)color).getBlue() - 127.5f) / 128.0f;
            }
        }
        Object[] $this$flatMap$iv = (Object[])rgb;
        boolean $i$f$flatMap = false;
        color = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            float[] it = (float[])element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((float[])it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
    }

    private final BufferedImage resizeNative(BufferedImage originalImage, int targetWidth, int targetHeight) {
        BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, 1);
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.drawImage(originalImage, 0, 0, targetWidth, targetHeight, null);
        graphics2D.dispose();
        Image tmp = originalImage.getScaledInstance(targetWidth, targetHeight, 16);
        graphics2D = resizedImage.createGraphics();
        graphics2D.drawImage(tmp, 0, 0, null);
        graphics2D.dispose();
        return resizedImage;
    }

    private final byte[] encodeInternal(float[] data2) {
        Map faceNetModelInputs = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, (Object)data2));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)new float[this.faceNetModelConfig.getOutputLength()])};
        Map faceNetModelOutputs = MapsKt.mutableMapOf((Pair[])pairArray);
        this.interpreter.invoke(faceNetModelInputs, faceNetModelOutputs);
        Object v = faceNetModelOutputs.get(0);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.FloatArray");
        return this.toByteArray((float[])v);
    }

    private final byte[] toByteArray(float[] $this$toByteArray) {
        ByteBuffer buffer = ByteBuffer.allocate($this$toByteArray.length * 4);
        buffer.asFloatBuffer().put($this$toByteArray);
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
        return byArray;
    }
}

