/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.core.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.iriscan.sdk.io.image.ImageFormat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005H\u0000\u001a \u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0007\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\b\u001a\u00020\tH\u0000*\n\u0010\n\"\u00020\u00012\u00020\u0001\u00a8\u0006\u000b"}, d2={"internalReadNativeImage", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "dataBytes", "", "Lnet/iriscan/sdk/core/io/DataBytes;", "internalWriteNativeImage", "image", "format", "Lnet/iriscan/sdk/io/image/ImageFormat;", "NativeImage", "biometric-sdk"})
public final class NativeImageKt {
    @NotNull
    public static final BufferedImage internalReadNativeImage(@NotNull byte[] dataBytes) {
        Intrinsics.checkNotNullParameter((Object)dataBytes, (String)"dataBytes");
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(dataBytes));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(ByteArrayInputStream(dataBytes))");
        return bufferedImage;
    }

    @NotNull
    public static final byte[] internalWriteNativeImage(@NotNull BufferedImage image, @NotNull ImageFormat format) {
        String string;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                string = "bmp";
                break;
            }
            case 2: {
                string = "png";
                break;
            }
            case 3: {
                string = "jpg";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String writeFormat = string;
        ByteArrayOutputStream outs = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, writeFormat, outs);
        byte[] byArray = outs.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outs.toByteArray()");
        return byArray;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageFormat.values().length];
            try {
                nArray[ImageFormat.BMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFormat.PNG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFormat.JPEG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

