/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.iris.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.image.ImageColorType;
import net.iriscan.sdk.core.utils.ImageUtilsKt;
import net.iriscan.sdk.iris.IrisEncodeProperties;
import net.iriscan.sdk.iris.impl.IrisEncodeOperationsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0007"}, d2={"encodeInternal", "", "texture", "Lnet/iriscan/sdk/core/image/Image;", "props", "Lnet/iriscan/sdk/iris/IrisEncodeProperties;", "extractNBP", "biometric-sdk"})
public final class IrisEncodeOperationsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] encodeInternal(@NotNull Image texture, @NotNull IrisEncodeProperties props) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        if (!(texture.getColorType() == ImageColorType.GRAY)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Ref.ObjectRef image = new Ref.ObjectRef();
        image.element = texture.clone();
        ImageUtilsKt.normalizeHistogramImg$default((Image)image.element, null, 2, null);
        image.element = IrisEncodeOperationsKt.extractNBP(texture);
        int templateWidth = props.getTemplateWidth();
        int templateHeight = props.getTemplateHeight();
        int blockWidth = ((Image)image.element).getWidth() / templateWidth;
        int blockHeight = ((Image)image.element).getHeight() / templateHeight;
        Image means2 = ImageUtilsKt.createImg(templateWidth, templateHeight, ImageColorType.GRAY, (Function2<? super Integer, ? super Integer, Integer>)((Function2)new Function2<Integer, Integer, Integer>((Ref.ObjectRef<Image>)image, blockWidth, blockHeight){
            final /* synthetic */ Ref.ObjectRef<Image> $image;
            final /* synthetic */ int $blockWidth;
            final /* synthetic */ int $blockHeight;
            {
                this.$image = $image;
                this.$blockWidth = $blockWidth;
                this.$blockHeight = $blockHeight;
                super(2);
            }

            @NotNull
            public final Integer invoke(int x, int y) {
                return (int)ArraysKt.average((int[])((Image)this.$image.element).get(new IntRange(x * this.$blockWidth, x * this.$blockWidth + x), new IntRange(y * this.$blockHeight, y * this.$blockHeight + y)).getColors());
            }
        }));
        Iterable iterable = CollectionsKt.chunked((Iterable)ArraysKt.toList((int[])means2.getColors()), (int)templateWidth);
        Collection collection = new ArrayList();
        int n = 0;
        for (Object t : iterable) {
            List list;
            void row;
            boolean bl;
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)t;
            int index = n2;
            boolean bl2 = false;
            boolean bl3 = bl = index % 2 == 0;
            if (bl) {
                list = row;
            } else if (!bl) {
                list = CollectionsKt.reversed((Iterable)((Iterable)row));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            CollectionsKt.addAll((Collection)collection, (Iterable)list);
        }
        return CollectionsKt.toByteArray((Collection)CollectionsKt.windowed$default((Iterable)((List)collection), (int)2, (int)0, (boolean)false, (Function1)encodeInternal.2.INSTANCE, (int)6, null));
    }

    private static final Image extractNBP(Image texture) {
        Image result2 = texture.clone();
        int n = texture.getWidth() - 1;
        for (int x = 1; x < n; ++x) {
            int n2 = texture.getHeight() - 1;
            for (int y = 1; y < n2; ++y) {
                Object[] objectArray = new Integer[]{texture.get(x - 1, y - 1), texture.get(x, y - 1), texture.get(x + 1, y - 1), texture.get(x + 1, y), texture.get(x + 1, y + 1), texture.get(x, y + 1), texture.get(x - 1, y + 1), texture.get(x - 1, y)};
                List bytesList = CollectionsKt.listOf((Object[])objectArray);
                String bytes2 = ((Object)StringsKt.reversed((CharSequence)CollectionsKt.joinToString$default((Iterable)CollectionsKt.windowed$default((Iterable)bytesList, (int)2, (int)0, (boolean)false, (Function1)extractNBP.bytes.1.INSTANCE, (int)6, null), (CharSequence)"", null, null, (int)0, null, null, (int)62, null))).toString();
                result2.set(x, y, Integer.parseInt(bytes2, CharsKt.checkRadix((int)2)));
            }
        }
        return result2;
    }
}

