/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.face.impl;

import com.soywiz.korio.util.BufferExtKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.image.ColorKt;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.tf.InterpreterImpl;
import net.iriscan.sdk.core.utils.ImageUtilsKt;
import net.iriscan.sdk.face.FaceNetModelConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0007\u001a\u00060\bj\u0002`\u000b2\n\u0010\t\u001a\u00060\fj\u0002`\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/iriscan/sdk/face/impl/FaceEncoderInternal;", "", "faceNetModelConfig", "Lnet/iriscan/sdk/face/FaceNetModelConfiguration;", "(Lnet/iriscan/sdk/face/FaceNetModelConfiguration;)V", "interpreter", "Lnet/iriscan/sdk/core/tf/InterpreterImpl;", "encode", "", "image", "Lnet/iriscan/sdk/core/image/Image;", "Lnet/iriscan/sdk/core/io/DataBytes;", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "encodeInternal", "data", "", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nFaceEncoderInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaceEncoderInternal.kt\nnet/iriscan/sdk/face/impl/FaceEncoderInternal\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,69:1\n10242#2:70\n10664#2,5:71\n10242#2:76\n10664#2,5:77\n*S KotlinDebug\n*F\n+ 1 FaceEncoderInternal.kt\nnet/iriscan/sdk/face/impl/FaceEncoderInternal\n*L\n34#1:70\n34#1:71,5\n57#1:76\n57#1:77,5\n*E\n"})
public final class FaceEncoderInternal {
    @NotNull
    private final FaceNetModelConfiguration faceNetModelConfig;
    @NotNull
    private final InterpreterImpl interpreter;

    public FaceEncoderInternal(@NotNull FaceNetModelConfiguration faceNetModelConfig) {
        Intrinsics.checkNotNullParameter((Object)faceNetModelConfig, (String)"faceNetModelConfig");
        this.faceNetModelConfig = faceNetModelConfig;
        this.interpreter = new InterpreterImpl(this.faceNetModelConfig.getTfliteModelPath(), this.faceNetModelConfig.getModelChecksum());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] encode(@NotNull Image image) {
        void $this$flatMapTo$iv$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Image resized = ImageUtilsKt.resizeImg(image, this.faceNetModelConfig.getInputWidth(), this.faceNetModelConfig.getInputHeight());
        int n2 = 0;
        int n3 = resized.getWidth() * resized.getHeight();
        float[][] fArrayArray = new float[n3][];
        while (n2 < n3) {
            n = n2++;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
            fArrayArray[n] = fArray;
        }
        float[][] rgb = fArrayArray;
        n3 = image.getHeight();
        for (int y = 0; y < n3; ++y) {
            n = image.getWidth();
            for (int x = 0; x < n; ++x) {
                int color = resized.get(x, y);
                int i = y * resized.getWidth() + x;
                rgb[i][0] = ((float)ColorKt.red(color) - 127.5f) / 128.0f;
                rgb[i][1] = ((float)ColorKt.green(color) - 127.5f) / 128.0f;
                rgb[i][2] = ((float)ColorKt.blue(color) - 127.5f) / 128.0f;
            }
        }
        Object[] $this$flatMap$iv = (Object[])rgb;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            float[] it = (float[])element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((float[])it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        float[] data = CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
        return this.encodeInternal(data);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] encode(@NotNull BufferedImage image) {
        void $this$flatMapTo$iv$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage resized = new BufferedImage(this.faceNetModelConfig.getInputWidth(), this.faceNetModelConfig.getInputHeight(), 1);
        Graphics2D g2d = resized.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(image, 0, 0, this.faceNetModelConfig.getInputWidth(), this.faceNetModelConfig.getInputHeight(), null);
        g2d.dispose();
        int n2 = 0;
        int n3 = resized.getWidth() * resized.getHeight();
        float[][] fArrayArray = new float[n3][];
        while (n2 < n3) {
            n = n2++;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
            fArrayArray[n] = fArray;
        }
        float[][] rgb = fArrayArray;
        n3 = image.getHeight();
        for (int y = 0; y < n3; ++y) {
            n = image.getWidth();
            for (int x = 0; x < n; ++x) {
                Color color = new Color(image.getRGB(x, y));
                int i = y * resized.getWidth() + x;
                rgb[i][0] = ((float)color.getRed() - 127.5f) / 128.0f;
                rgb[i][1] = ((float)color.getGreen() - 127.5f) / 128.0f;
                rgb[i][2] = ((float)color.getBlue() - 127.5f) / 128.0f;
            }
        }
        Object[] $this$flatMap$iv = (Object[])rgb;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            float[] it = (float[])element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((float[])it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        float[] data = CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
        return this.encodeInternal(data);
    }

    private final byte[] encodeInternal(float[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length * 4);
        buffer.asFloatBuffer().put(data);
        Integer n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        Map faceNetModelInputs = MapsKt.mapOf((Pair)TuplesKt.to((Object)n, (Object)BufferExtKt.toByteArray((ByteBuffer)buffer)));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)new byte[this.faceNetModelConfig.getOutputLength()])};
        Map faceNetModelOutputs = MapsKt.mutableMapOf((Pair[])pairArray);
        this.interpreter.invoke(faceNetModelInputs, faceNetModelOutputs);
        Object v = faceNetModelOutputs.get(0);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.ByteArray");
        return (byte[])v;
    }
}

