/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.core.tf;

import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.io.ResourceHelperFactory;
import net.iriscan.sdk.core.tf.Interpreter;
import net.iriscan.sdk.core.tf.TfStatusHelperKt;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.tensorflowlite.BuiltinOpResolver;
import org.bytedeco.tensorflowlite.FlatBufferModel;
import org.bytedeco.tensorflowlite.InterpreterBuilder;
import org.bytedeco.tensorflowlite.OpResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/iriscan/sdk/core/tf/InterpreterImpl;", "Lnet/iriscan/sdk/core/tf/Interpreter;", "modelPath", "", "modelChecksum", "", "(Ljava/lang/String;I)V", "interpreter", "Lorg/bytedeco/tensorflowlite/Interpreter;", "invoke", "", "inputs", "", "", "outputs", "", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpreter.kt\nnet/iriscan/sdk/core/tf/InterpreterImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1855#2,2:49\n1855#2,2:51\n*S KotlinDebug\n*F\n+ 1 Interpreter.kt\nnet/iriscan/sdk/core/tf/InterpreterImpl\n*L\n29#1:49,2\n38#1:51,2\n*E\n"})
public final class InterpreterImpl
implements Interpreter {
    @NotNull
    private final org.bytedeco.tensorflowlite.Interpreter interpreter;

    public InterpreterImpl(@NotNull String modelPath, int modelChecksum) {
        Intrinsics.checkNotNullParameter((Object)modelPath, (String)"modelPath");
        this.interpreter = new org.bytedeco.tensorflowlite.Interpreter(null);
        byte[] modelBytes = ResourceHelperFactory.INSTANCE.getInstance().read(modelPath);
        InterpreterBuilder builder = new InterpreterBuilder(FlatBufferModel.BuildFromBuffer((BytePointer)new BytePointer(ByteBuffer.wrap(modelBytes)), (long)modelBytes.length), (OpResolver)new BuiltinOpResolver());
        builder.apply(this.interpreter);
        this.interpreter.AllocateTensors();
    }

    @Override
    public void invoke(@NotNull Map<Integer, ? extends Object> inputs, @NotNull Map<Integer, Object> outputs) {
        int it;
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        Iterable $this$forEach$iv = inputs.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).intValue();
            boolean bl = false;
            Object object = inputs.get(it);
            Intrinsics.checkNotNull((Object)object);
            byte[] data = (byte[])object;
            this.interpreter.input_tensor((long)it).data().raw().put(data, 0, data.length);
        }
        TfStatusHelperKt.tfIfErrorThrow(this.interpreter.Invoke(), "Could not invoke model");
        $this$forEach$iv = outputs.keySet();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).intValue();
            boolean bl = false;
            Object object = outputs.get(it);
            Intrinsics.checkNotNull((Object)object);
            byte[] out = (byte[])object;
            this.interpreter.output_tensor((long)it).data().raw().get(out);
        }
        this.interpreter.close();
    }
}

