/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.io.image.serializers;

import com.soywiz.kmem.ByteArrayBuilder;
import com.soywiz.kmem.ByteArrayReadWriteKt;
import com.soywiz.korio.stream.SyncInputStream;
import com.soywiz.korio.stream.SyncOutputStream;
import com.soywiz.korio.stream.SyncStream;
import com.soywiz.korio.stream.SyncStreamKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.UInt;
import kotlin.UnsignedKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.image.ImageColorType;
import net.iriscan.sdk.io.exception.IOException;
import net.iriscan.sdk.io.image.ImageFormat;
import net.iriscan.sdk.io.image.ImageSerializer;
import net.iriscan.sdk.io.image.serializers.PngChunkData;
import net.iriscan.sdk.io.image.serializers.PngHelperKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u0019\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0012"}, d2={"Lnet/iriscan/sdk/io/image/serializers/PNG;", "Lnet/iriscan/sdk/io/image/ImageSerializer;", "()V", "MAGIC", "Lkotlin/UByteArray;", "[B", "format", "Lnet/iriscan/sdk/io/image/ImageFormat;", "getFormat", "()Lnet/iriscan/sdk/io/image/ImageFormat;", "canRead", "", "data", "", "read", "Lnet/iriscan/sdk/core/image/Image;", "write", "image", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nPNG.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PNG.kt\nnet/iriscan/sdk/io/image/serializers/PNG\n+ 2 SyncStream.kt\ncom/soywiz/korio/stream/SyncStreamKt\n*L\n1#1,100:1\n264#2,5:101\n*S KotlinDebug\n*F\n+ 1 PNG.kt\nnet/iriscan/sdk/io/image/serializers/PNG\n*L\n93#1:101,5\n*E\n"})
public final class PNG
implements ImageSerializer {
    @NotNull
    public static final PNG INSTANCE = new PNG();
    @NotNull
    private static final byte[] MAGIC;

    private PNG() {
    }

    @Override
    @NotNull
    public ImageFormat getFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public boolean canRead(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return data.length > 8 && UArraysKt.contentEquals-kV0jMPg((byte[])SyncStreamKt.readUByteArray((SyncInputStream)((SyncInputStream)SyncStreamKt.MemorySyncStream((byte[])data)), (int)8), (byte[])MAGIC);
    }

    @Override
    @NotNull
    public Image read(@NotNull byte[] data) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SyncStream stream = SyncStreamKt.MemorySyncStream((byte[])data);
        stream.skip(8);
        PngChunkData pngData = PngHelperKt.readPngChunks(stream);
        switch (pngData.getColorType()) {
            case 2: {
                n = 3;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            default: {
                throw new IOException("Unsupported color type " + pngData.getColorType(), null, 2, null);
            }
        }
        int bytesPerPixel = n;
        SyncStream dataStream = SyncStreamKt.MemorySyncStream((byte[])pngData.getData());
        byte[] previous = new byte[]{};
        byte[] current = null;
        int rowWidth = pngData.getWidth() * bytesPerPixel;
        int[] colors = new int[pngData.getWidth() * pngData.getHeight()];
        int n2 = pngData.getHeight();
        block15: for (int y = 0; y < n2; ++y) {
            int n3;
            int n4;
            int filterType = SyncStreamKt.readU8((SyncInputStream)((SyncInputStream)dataStream));
            current = SyncStreamKt.readUByteArray((SyncInputStream)((SyncInputStream)dataStream), (int)rowWidth);
            switch (filterType) {
                case 0: {
                    break;
                }
                case 1: {
                    byte by;
                    int n5;
                    n4 = UByteArray.getSize-impl((byte[])current);
                    for (n5 = bytesPerPixel; n5 < n4; ++n5) {
                        n3 = UByteArray.get-w2LRezQ((byte[])current, (int)n5);
                        by = UByteArray.get-w2LRezQ((byte[])current, (int)(n5 - bytesPerPixel));
                        UByteArray.set-VurrAj0((byte[])current, (int)n5, (byte)UByte.constructor-impl((byte)((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(n3 & 0xFF)) + UInt.constructor-impl((int)(by & 0xFF)))))));
                    }
                    break;
                }
                case 2: {
                    byte by;
                    int n5;
                    n4 = UByteArray.getSize-impl((byte[])current);
                    for (n5 = 0; n5 < n4; ++n5) {
                        n3 = UByteArray.get-w2LRezQ((byte[])current, (int)n5);
                        by = UByteArray.get-w2LRezQ((byte[])previous, (int)n5);
                        UByteArray.set-VurrAj0((byte[])current, (int)n5, (byte)UByte.constructor-impl((byte)((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(n3 & 0xFF)) + UInt.constructor-impl((int)(by & 0xFF)))))));
                    }
                    break;
                }
                case 3: {
                    int n5;
                    for (n5 = 0; n5 < bytesPerPixel; ++n5) {
                        int a = UByteArray.get-w2LRezQ((byte[])current, (int)n5) & 0xFF;
                        int b = UByteArray.get-w2LRezQ((byte[])previous, (int)n5) & 0xFF;
                        UByteArray.set-VurrAj0((byte[])current, (int)n5, (byte)UByte.constructor-impl((byte)((byte)(a + b / 2))));
                    }
                    n4 = UByteArray.getSize-impl((byte[])current);
                    for (n5 = bytesPerPixel; n5 < n4; ++n5) {
                        int a = UByteArray.get-w2LRezQ((byte[])current, (int)n5) & 0xFF;
                        int b = UByteArray.get-w2LRezQ((byte[])current, (int)(n5 - bytesPerPixel)) & 0xFF;
                        int c = UByteArray.get-w2LRezQ((byte[])previous, (int)n5) & 0xFF;
                        UByteArray.set-VurrAj0((byte[])current, (int)n5, (byte)UByte.constructor-impl((byte)((byte)UnsignedKt.doubleToUInt((double)((double)a + Math.floor((double)(b + c) / 2.0))))));
                    }
                    break;
                }
                case 4: {
                    int n5;
                    for (n5 = 0; n5 < bytesPerPixel; ++n5) {
                        n4 = UByteArray.get-w2LRezQ((byte[])current, (int)n5);
                        n3 = UByteArray.get-w2LRezQ((byte[])previous, (int)n5);
                        UByteArray.set-VurrAj0((byte[])current, (int)n5, (byte)UByte.constructor-impl((byte)((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(n4 & 0xFF)) + UInt.constructor-impl((int)(n3 & 0xFF)))))));
                    }
                    n4 = UByteArray.getSize-impl((byte[])current);
                    for (n5 = bytesPerPixel; n5 < n4; ++n5) {
                        UByteArray.set-VurrAj0((byte[])current, (int)n5, (byte)UByte.constructor-impl((byte)((byte)((UByteArray.get-w2LRezQ((byte[])current, (int)n5) & 0xFF) + PngHelperKt.paethPredictor(UByteArray.get-w2LRezQ((byte[])current, (int)(n5 - bytesPerPixel)) & 0xFF, UByteArray.get-w2LRezQ((byte[])previous, (int)n5) & 0xFF, UByteArray.get-w2LRezQ((byte[])previous, (int)(n5 - bytesPerPixel)) & 0xFF)))));
                    }
                    break;
                }
            }
            byte[] byArray = Arrays.copyOf(current, current.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
            previous = UByteArray.constructor-impl((byte[])byArray);
            int n6 = UByteArray.getSize-impl((byte[])current) + -1;
            if (bytesPerPixel <= 0) {
                throw new IllegalArgumentException("Step must be positive, was: " + bytesPerPixel + ".");
            }
            int n7 = 0;
            n4 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n6, (int)bytesPerPixel);
            n3 = 0;
            if (n7 > n4) continue;
            while (true) {
                int n8;
                int x = n3++;
                int off = n7;
                int n9 = y * pngData.getWidth() + x;
                switch (bytesPerPixel) {
                    case 3: {
                        n8 = ByteArrayReadWriteKt.readS24LE((byte[])current, (int)off);
                        break;
                    }
                    case 4: {
                        n8 = ByteArrayReadWriteKt.readS32LE((byte[])current, (int)off);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Bytes per pixel " + bytesPerPixel + " is not supported");
                    }
                }
                colors[n9] = n8;
                if (off == n4) continue block15;
                n7 += bytesPerPixel;
            }
        }
        return new Image(pngData.getWidth(), pngData.getHeight(), ImageColorType.RGB, colors);
    }

    @Override
    @NotNull
    public byte[] write(@NotNull Image image) {
        SyncStream s$iv;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int initialCapacity$iv = 4096;
        boolean $i$f$MemorySyncStreamToByteArray = false;
        ByteArrayBuilder buffer$iv = new ByteArrayBuilder(initialCapacity$iv);
        SyncStream $this$write_u24lambda_u240 = s$iv = SyncStreamKt.MemorySyncStream((ByteArrayBuilder)buffer$iv);
        boolean bl = false;
        SyncOutputStream syncOutputStream = (SyncOutputStream)$this$write_u24lambda_u240;
        byte[] byArray = Arrays.copyOf(MAGIC, MAGIC.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        SyncStreamKt.writeBytes((SyncOutputStream)syncOutputStream, (byte[])byArray);
        PngHelperKt.writeChunk($this$write_u24lambda_u240, "IHDR", image);
        PngHelperKt.writeChunk($this$write_u24lambda_u240, "IDAT", image);
        PngHelperKt.writeChunk($this$write_u24lambda_u240, "IEND", image);
        return buffer$iv.toByteArray();
    }

    static {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        MAGIC = byArray;
    }
}

