/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.io.image.serializers;

import com.soywiz.kmem.ByteArrayBuilder;
import com.soywiz.korio.stream.SyncInputStream;
import com.soywiz.korio.stream.SyncOutputStream;
import com.soywiz.korio.stream.SyncStream;
import com.soywiz.korio.stream.SyncStreamKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.image.ImageColorType;
import net.iriscan.sdk.io.exception.IOException;
import net.iriscan.sdk.io.image.ImageFormat;
import net.iriscan.sdk.io.image.ImageSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lnet/iriscan/sdk/io/image/serializers/BMP;", "Lnet/iriscan/sdk/io/image/ImageSerializer;", "()V", "format", "Lnet/iriscan/sdk/io/image/ImageFormat;", "getFormat", "()Lnet/iriscan/sdk/io/image/ImageFormat;", "canRead", "", "data", "", "read", "Lnet/iriscan/sdk/core/image/Image;", "readColors", "", "stream", "Lcom/soywiz/korio/stream/SyncStream;", "bitsPerPixel", "", "width", "height", "write", "image", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nBMP.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BMP.kt\nnet/iriscan/sdk/io/image/serializers/BMP\n+ 2 SyncStream.kt\ncom/soywiz/korio/stream/SyncStreamKt\n*L\n1#1,109:1\n264#2,5:110\n*S KotlinDebug\n*F\n+ 1 BMP.kt\nnet/iriscan/sdk/io/image/serializers/BMP\n*L\n72#1:110,5\n*E\n"})
public final class BMP
implements ImageSerializer {
    @NotNull
    public static final BMP INSTANCE = new BMP();

    private BMP() {
    }

    @Override
    @NotNull
    public ImageFormat getFormat() {
        return ImageFormat.BMP;
    }

    @Override
    public boolean canRead(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return data.length > 4 && Intrinsics.areEqual((Object)SyncStreamKt.readStringz$default((SyncInputStream)((SyncInputStream)SyncStreamKt.MemorySyncStream((byte[])data)), (int)2, null, (int)2, null), (Object)"BM");
    }

    @Override
    @NotNull
    public Image read(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SyncStream stream = SyncStreamKt.MemorySyncStream((byte[])data);
        if (stream.getAvailableRead() < 54L) {
            throw new IOException("Unexpected EOF", null, 2, null);
        }
        stream.skip(10);
        int dataOffset = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)stream));
        stream.skip(4);
        int width = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)stream));
        int height = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)stream));
        stream.skip(2);
        int bitsPerPixel = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)stream));
        int compression = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)stream));
        if (compression != 0) {
            throw new IOException("Unsupported BMP compression " + compression, null, 2, null);
        }
        int imageSize = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)stream));
        stream.skip(16);
        if (dataOffset > 54) {
            stream.skip(dataOffset - 54);
        }
        if (stream.getAvailableRead() < (long)imageSize) {
            throw new IOException("Unexpected EOF", null, 2, null);
        }
        int[] colors = this.readColors(stream, bitsPerPixel, width, height);
        return new Image(width, height, ImageColorType.RGB, colors);
    }

    private final int[] readColors(SyncStream stream, int bitsPerPixel, int width, int height) {
        int padding = 4 - width * 24 / 8 % 4;
        int skip = padding == 4 ? 0 : padding;
        int[] result2 = new int[height * width];
        switch (bitsPerPixel) {
            case 24: 
            case 32: {
                for (int y = height - 1; -1 < y; --y) {
                    for (int x = 0; x < width; ++x) {
                        result2[y * width + x] = SyncStreamKt.readS24LE((SyncInputStream)((SyncInputStream)stream));
                    }
                    stream.skip(skip);
                }
                break;
            }
            default: {
                throw new IOException("Unsupported bits per pixel " + bitsPerPixel, null, 2, null);
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public byte[] write(@NotNull Image image) {
        SyncStream s$iv;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int initialCapacity$iv = 4096;
        boolean $i$f$MemorySyncStreamToByteArray = false;
        ByteArrayBuilder buffer$iv = new ByteArrayBuilder(initialCapacity$iv);
        SyncStream $this$write_u24lambda_u240 = s$iv = SyncStreamKt.MemorySyncStream((ByteArrayBuilder)buffer$iv);
        boolean bl = false;
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)66);
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)77);
        int imageSize = image.getSize() * 24 / 8;
        int fileSize = 54 + imageSize;
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)fileSize);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)0);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)54);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)40);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)image.getWidth());
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)image.getHeight());
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)1);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)24);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)imageSize);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)0);
        int padding = 4 - image.getWidth() * 24 / 8 % 4;
        byte[] widthPadding = padding == 4 ? new byte[]{} : new byte[padding];
        for (int y = image.getHeight() - 1; -1 < y; --y) {
            int n = image.getWidth();
            for (int x = 0; x < n; ++x) {
                SyncStreamKt.write24LE((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (int)image.get(x, y));
            }
            SyncStreamKt.writeBytes((SyncOutputStream)((SyncOutputStream)$this$write_u24lambda_u240), (byte[])widthPadding);
        }
        return buffer$iv.toByteArray();
    }
}

