/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.core.image;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.iriscan.sdk.core.image.ImageColorType;
import net.iriscan.sdk.core.image.Point;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0086\u0002J\u0019\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002J!\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006$"}, d2={"Lnet/iriscan/sdk/core/image/Image;", "", "width", "", "height", "colorType", "Lnet/iriscan/sdk/core/image/ImageColorType;", "colors", "", "(IILnet/iriscan/sdk/core/image/ImageColorType;[I)V", "getColorType", "()Lnet/iriscan/sdk/core/image/ImageColorType;", "setColorType", "(Lnet/iriscan/sdk/core/image/ImageColorType;)V", "getColors", "()[I", "getHeight", "()I", "size", "getSize", "getWidth", "clone", "contains", "", "point", "Lnet/iriscan/sdk/core/image/Point;", "get", "index", "x", "y", "xRange", "Lkotlin/ranges/IntRange;", "yRange", "set", "", "color", "biometric-sdk"})
public final class Image {
    private final int width;
    private final int height;
    @NotNull
    private ImageColorType colorType;
    @NotNull
    private final int[] colors;
    private final int size;

    public Image(int width, int height, @NotNull ImageColorType colorType, @NotNull int[] colors) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.width = width;
        this.height = height;
        this.colorType = colorType;
        this.colors = colors;
        this.size = this.colors.length;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final ImageColorType getColorType() {
        return this.colorType;
    }

    public final void setColorType(@NotNull ImageColorType imageColorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageColorType), (String)"<set-?>");
        this.colorType = imageColorType;
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    public final int getSize() {
        return this.size;
    }

    public final int get(int x, int y) {
        return this.colors[y * this.width + x];
    }

    public final int get(int index) {
        return this.colors[index];
    }

    @NotNull
    public final Image get(@NotNull IntRange xRange, @NotNull IntRange yRange) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        int newWidth = CollectionsKt.count((Iterable)((Iterable)xRange));
        int newHeight = CollectionsKt.count((Iterable)((Iterable)yRange));
        int[] colors = new int[newWidth * newHeight];
        int index = 0;
        int y = yRange.getFirst();
        int n = yRange.getLast();
        if (y <= n) {
            while (true) {
                int n2;
                int x;
                if ((x = xRange.getFirst()) <= (n2 = xRange.getLast())) {
                    while (true) {
                        colors[index++] = this.get(x, y);
                        if (x == n2) break;
                        ++x;
                    }
                }
                if (y == n) break;
                ++y;
            }
        }
        return new Image(newWidth, newHeight, this.colorType, colors);
    }

    public final boolean contains(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return point.getY() * this.width + point.getX() < this.colors.length;
    }

    public final void set(int x, int y, int color) {
        this.colors[y * this.width + x] = color;
    }

    public final void set(int index, int color) {
        this.colors[index] = color;
    }

    @NotNull
    public final Image clone() {
        int n = 0;
        int n2 = this.colors.length;
        int[] nArray = new int[n2];
        ImageColorType imageColorType = this.colorType;
        int n3 = this.height;
        int n4 = this.width;
        while (n < n2) {
            int n5 = n++;
            nArray[n5] = this.colors[n5];
        }
        int[] nArray2 = nArray;
        ImageColorType imageColorType2 = imageColorType;
        int n6 = n3;
        int n7 = n4;
        return new Image(n7, n6, imageColorType2, nArray2);
    }
}

