/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.io.image.serializers;

import com.soywiz.kmem.ByteArrayBuilder;
import com.soywiz.korio.compression.CompressionMethod;
import com.soywiz.korio.compression.CompressionMethodKt;
import com.soywiz.korio.compression.deflate.ZLib;
import com.soywiz.korio.lang.CharsetKt;
import com.soywiz.korio.stream.SyncInputStream;
import com.soywiz.korio.stream.SyncOutputStream;
import com.soywiz.korio.stream.SyncStream;
import com.soywiz.korio.stream.SyncStreamKt;
import com.soywiz.korio.util.checksum.CRC32;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.io.exception.IOException;
import net.iriscan.sdk.io.image.serializers.PngChunkData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a8\u0006\u0015"}, d2={"paethPredictor", "", "a", "b", "c", "readChunks", "", "stream", "Lcom/soywiz/korio/stream/SyncStream;", "data", "Lnet/iriscan/sdk/io/image/serializers/PngChunkData;", "readIDAT", "length", "readIHDR", "readPLTE", "readPngChunks", "writeChunk", "name", "", "image", "Lnet/iriscan/sdk/core/image/Image;", "biometric-sdk"})
public final class PngHelperKt {
    @NotNull
    public static final PngChunkData readPngChunks(@NotNull SyncStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        PngChunkData data = new PngChunkData(0, 0, 0, null, null, 31, null);
        int length = SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)stream));
        if (stream.getAvailableRead() < (long)length) {
            throw new IOException("Invalid png file, unexpected EOF on IHDR read", null, 2, null);
        }
        String type = SyncStreamKt.readStringz$default((SyncInputStream)((SyncInputStream)stream), (int)4, null, (int)2, null);
        if (!Intrinsics.areEqual((Object)type, (Object)"IHDR")) {
            throw new IOException("Invalid png file, no IHDR chunk available", null, 2, null);
        }
        PngHelperKt.readIHDR(stream, data);
        PngHelperKt.readChunks(stream, data);
        return data;
    }

    private static final void readChunks(SyncStream stream, PngChunkData data) {
        int length = SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)stream));
        switch (SyncStreamKt.readStringz$default((SyncInputStream)((SyncInputStream)stream), (int)4, null, (int)2, null)) {
            case "PLTE": {
                PngHelperKt.readPLTE(stream, length, data);
                break;
            }
            case "IDAT": {
                PngHelperKt.readIDAT(stream, length, data);
                break;
            }
            case "IEND": {
                return;
            }
            default: {
                stream.skip(length);
            }
        }
        stream.skip(4);
        PngHelperKt.readChunks(stream, data);
    }

    private static final void readIHDR(SyncStream stream, PngChunkData data) {
        data.setWidth(SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)stream)));
        data.setHeight(SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)stream)));
        stream.skip(1);
        data.setColorType(SyncStreamKt.readS8((SyncInputStream)((SyncInputStream)stream)));
        stream.skip(3);
        stream.skip(4);
    }

    private static final void readPLTE(SyncStream stream, int length, PngChunkData data) {
        data.setPalette(SyncStreamKt.readBytes((SyncInputStream)((SyncInputStream)stream), (int)length));
    }

    private static final void readIDAT(SyncStream stream, int length, PngChunkData data) {
        data.setData(CompressionMethodKt.uncompress$default((byte[])SyncStreamKt.readBytes((SyncInputStream)((SyncInputStream)stream), (int)length), (CompressionMethod)((CompressionMethod)ZLib.Companion), (int)0, (int)2, null));
    }

    public static final int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        return pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void writeChunk(@NotNull SyncStream stream, @NotNull String name, @NotNull Image image) {
        int crc;
        block10: {
            block9: {
                void $this$mapTo$iv$iv;
                SyncStream s$iv;
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                crc = CRC32.INSTANCE.getInitialValue();
                String string = name;
                switch (string.hashCode()) {
                    case 2243538: {
                        if (!string.equals("IEND")) {
                            throw new IOException("Unknown chunk", null, 2, null);
                        }
                        break block9;
                    }
                    case 2242190: {
                        if (string.equals("IDAT")) break;
                        throw new IOException("Unknown chunk", null, 2, null);
                    }
                    case 2246125: {
                        if (!string.equals("IHDR")) throw new IOException("Unknown chunk", null, 2, null);
                        SyncStreamKt.write32BE((SyncOutputStream)((SyncOutputStream)stream), (int)13);
                        SyncStreamKt.writeBytes((SyncOutputStream)((SyncOutputStream)stream), (byte[])CharsetKt.toByteArray$default((String)"IHDR", null, (int)0, (int)0, (int)7, null));
                        SyncStreamKt.write32BE((SyncOutputStream)((SyncOutputStream)stream), (int)image.getWidth());
                        SyncStreamKt.write32BE((SyncOutputStream)((SyncOutputStream)stream), (int)image.getHeight());
                        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)stream), (int)8);
                        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)stream), (int)2);
                        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)stream), (int)0);
                        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)stream), (int)0);
                        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)stream), (int)0);
                        crc = CRC32.INSTANCE.update(crc, CharsetKt.toByteArray$default((String)name, null, (int)0, (int)0, (int)7, null), 0, CharsetKt.toByteArray$default((String)name, null, (int)0, (int)0, (int)7, null).length);
                        byte[] writtenData = SyncStreamKt.toByteArray((SyncStream)stream);
                        byte[] data = ArraysKt.sliceArray((byte[])writtenData, (IntRange)RangesKt.until((int)(writtenData.length - 13), (int)writtenData.length));
                        crc = CRC32.INSTANCE.update(crc, data, 0, data.length);
                        break block10;
                    }
                }
                int initialCapacity$iv = 4096;
                boolean $i$f$MemorySyncStreamToByteArray = false;
                ByteArrayBuilder buffer$iv = new ByteArrayBuilder(initialCapacity$iv);
                SyncStream $this$writeChunk_u24lambda_u242 = s$iv = SyncStreamKt.MemorySyncStream((ByteArrayBuilder)buffer$iv);
                boolean bl = false;
                Iterable $this$map$iv = CollectionsKt.chunked((Iterable)ArraysKt.toList((int[])image.getColors()), (int)image.getWidth());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(CollectionsKt.toIntArray((Collection)((Collection)it)));
                }
                List colors = (List)destination$iv$iv;
                int n = image.getHeight();
                for (int y = 0; y < n; ++y) {
                    SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)$this$writeChunk_u24lambda_u242), (int)0);
                    int[] $this$forEach$iv = (int[])colors.get(y);
                    boolean $i$f$forEach = false;
                    int n2 = $this$forEach$iv.length;
                    for (int i = 0; i < n2; ++i) {
                        int element$iv;
                        int it = element$iv = $this$forEach$iv[i];
                        boolean bl3 = false;
                        SyncStreamKt.write24LE((SyncOutputStream)((SyncOutputStream)$this$writeChunk_u24lambda_u242), (int)it);
                    }
                }
                byte[] compressedData = buffer$iv.toByteArray();
                compressedData = CompressionMethodKt.compress$default((byte[])compressedData, (CompressionMethod)((CompressionMethod)ZLib.Companion), null, (int)0, (int)6, null);
                SyncStreamKt.write32BE((SyncOutputStream)((SyncOutputStream)stream), (int)compressedData.length);
                SyncStreamKt.writeBytes((SyncOutputStream)((SyncOutputStream)stream), (byte[])CharsetKt.toByteArray$default((String)"IDAT", null, (int)0, (int)0, (int)7, null));
                SyncStreamKt.writeBytes((SyncOutputStream)((SyncOutputStream)stream), (byte[])compressedData);
                crc = CRC32.INSTANCE.update(crc, CharsetKt.toByteArray$default((String)name, null, (int)0, (int)0, (int)7, null), 0, CharsetKt.toByteArray$default((String)name, null, (int)0, (int)0, (int)7, null).length);
                crc = CRC32.INSTANCE.update(crc, compressedData, 0, compressedData.length);
                break block10;
            }
            SyncStreamKt.write32BE((SyncOutputStream)((SyncOutputStream)stream), (int)0);
            SyncStreamKt.writeBytes((SyncOutputStream)((SyncOutputStream)stream), (byte[])CharsetKt.toByteArray$default((String)"IEND", null, (int)0, (int)0, (int)7, null));
            crc = CRC32.INSTANCE.update(crc, CharsetKt.toByteArray$default((String)name, null, (int)0, (int)0, (int)7, null), 0, CharsetKt.toByteArray$default((String)name, null, (int)0, (int)0, (int)7, null).length);
            crc = CRC32.INSTANCE.update(crc, new byte[0], 0, 0);
            break block10;
            throw new IOException("Unknown chunk", null, 2, null);
        }
        SyncStreamKt.write32BE((SyncOutputStream)((SyncOutputStream)stream), (int)crc);
    }
}

