/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.core.utils;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.iriscan.sdk.core.image.ColorKt;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.image.ImageColorType;
import net.iriscan.sdk.core.utils.ArrayUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001aZ\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u000626\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00030\bH\u0000\u001a(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0000\u001a/\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0000\u001a \u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0000\u001a7\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\"0 H\u0080\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"createImg", "Lnet/iriscan/sdk/core/image/Image;", "width", "", "height", "type", "Lnet/iriscan/sdk/core/image/ImageColorType;", "getColorAt", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "x", "y", "fillImg", "", "image", "threshold", "kernel", "fillKernel", "gaussianFilterImg", "mask", "", "", "divisor", "(Lnet/iriscan/sdk/core/image/Image;[[II)V", "grayscaleImg", "normalizeHistogramImg", "resizeImg", "newWidth", "newHeight", "thresholdImg", "condition", "Lkotlin/Function1;", "color", "", "biometric-sdk"})
public final class ImageUtilsKt {
    public static final void grayscaleImg(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.getColorType() == ImageColorType.GRAY) {
            return;
        }
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                int n3 = image.get(x, y);
                int red = ColorKt.component1(n3);
                int green = ColorKt.component2(n3);
                int blue = ColorKt.component3(n3);
                if (red == green && green == blue) {
                    image.set(x, y, red);
                    continue;
                }
                image.set(x, y, (red + green + blue) / 3);
            }
        }
        image.setColorType(ImageColorType.GRAY);
    }

    @NotNull
    public static final Image thresholdImg(@NotNull Image image, @NotNull Function1<? super Integer, Boolean> condition) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        boolean $i$f$thresholdImg = false;
        if (!(image.getColorType() == ImageColorType.GRAY)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Image result2 = image.clone();
        result2.setColorType(ImageColorType.BINARY);
        int n = result2.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = result2.getHeight();
            for (int y = 0; y < n2; ++y) {
                int n3;
                boolean bl = (Boolean)condition.invoke((Object)result2.get(x, y));
                if (bl) {
                    n3 = 1;
                } else if (!bl) {
                    n3 = 0;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                result2.set(x, y, n3);
            }
        }
        return result2;
    }

    public static final void fillImg(@NotNull Image image, int threshold, int kernel, int fillKernel) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (!(image.getColorType() == ImageColorType.GRAY)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= threshold ? threshold < 256 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int offset = kernel / 2;
        int fillOffset = fillKernel / 2;
        boolean $i$f$thresholdImg = false;
        if (!(image.getColorType() == ImageColorType.GRAY)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Image result$iv = image.clone();
        result$iv.setColorType(ImageColorType.BINARY);
        int n = result$iv.getWidth();
        for (int x$iv = 0; x$iv < n; ++x$iv) {
            int n2 = result$iv.getHeight();
            for (int y$iv = 0; y$iv < n2; ++y$iv) {
                int n3;
                int it;
                int n4 = result$iv.get(x$iv, y$iv);
                int n5 = y$iv;
                int n6 = x$iv;
                Image image2 = result$iv;
                boolean bl = false;
                int n7 = it > threshold ? 1 : 0;
                if ((it = n7) == 1) {
                    n3 = 1;
                } else if (it == 0) {
                    n3 = 0;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                image2.set(n6, n5, n3);
            }
        }
        Image thresholdMask = result$iv;
        int n8 = image.getWidth();
        for (int x = 0; x < n8; ++x) {
            n = image.getHeight();
            block3: for (int y = 0; y < n; ++y) {
                if (thresholdMask.get(x, y) == 0) continue;
                Pair pair = TuplesKt.to((Object)Math.max(x - offset, 0), (Object)Math.min(x + offset, image.getWidth() - 1));
                int kxmin = ((Number)pair.component1()).intValue();
                int kxmax = ((Number)pair.component2()).intValue();
                Pair pair2 = TuplesKt.to((Object)Math.max(y - offset, 0), (Object)Math.min(y + offset, image.getHeight() - 1));
                int kymin = ((Number)pair2.component1()).intValue();
                int kymax = ((Number)pair2.component2()).intValue();
                int[] pixels = new int[(kxmax - kxmin + 1) * (kymax - kymin + 1)];
                int k = 0;
                int xk = kxmin;
                if (xk <= kxmax) {
                    while (true) {
                        int yk;
                        if ((yk = kymin) <= kymax) {
                            while (true) {
                                pixels[k++] = image.get(xk, yk);
                                if (yk == kymax) break;
                                ++yk;
                            }
                        }
                        if (xk == kxmax) break;
                        ++xk;
                    }
                }
                int fillColor = (int)ArraysKt.average((int[])pixels);
                Pair pair3 = TuplesKt.to((Object)Math.max(x - fillOffset, 0), (Object)Math.min(x + fillOffset, image.getWidth() - 1));
                int jxmin = ((Number)pair3.component1()).intValue();
                int jxmax = ((Number)pair3.component2()).intValue();
                Pair pair4 = TuplesKt.to((Object)Math.max(y - fillOffset, 0), (Object)Math.min(y + fillOffset, image.getHeight() - 1));
                int jymin = ((Number)pair4.component1()).intValue();
                int jymax = ((Number)pair4.component2()).intValue();
                int xj = jxmin;
                if (xj > jxmax) continue;
                while (true) {
                    int yj;
                    if ((yj = jymin) <= jymax) {
                        while (true) {
                            image.set(xj, yj, fillColor);
                            if (yj == jymax) break;
                            ++yj;
                        }
                    }
                    if (xj == jxmax) continue block3;
                    ++xj;
                }
            }
        }
    }

    public static final void gaussianFilterImg(@NotNull Image image, @NotNull int[][] mask, int divisor) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        if (!(image.getColorType() == ImageColorType.GRAY)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                Pair pair = TuplesKt.to((Object)Math.max(x - 1, 0), (Object)Math.min(x + 1, image.getWidth() - 1));
                int xmin = ((Number)pair.component1()).intValue();
                int xmax = ((Number)pair.component2()).intValue();
                Pair pair2 = TuplesKt.to((Object)Math.max(y - 1, 0), (Object)Math.min(y + 1, image.getHeight() - 1));
                int ymin = ((Number)pair2.component1()).intValue();
                int ymax = ((Number)pair2.component2()).intValue();
                int[][] nArrayArray = new int[3][];
                int[] nArray = new int[]{image.get(xmin, ymin), image.get(x, ymin), image.get(xmax, ymin)};
                nArrayArray[0] = nArray;
                nArray = new int[]{image.get(xmin, y), image.get(x, y), image.get(xmax, y)};
                nArrayArray[1] = nArray;
                nArray = new int[]{image.get(xmin, ymax), image.get(x, ymax), image.get(xmax, ymax)};
                nArrayArray[2] = nArray;
                int[][] pixels = nArrayArray;
                image.set(x, y, Math.min(ArrayUtilsKt.sum(ArrayUtilsKt.times(pixels, mask)) / divisor, 255));
            }
        }
    }

    public static /* synthetic */ void gaussianFilterImg$default(Image image, int[][] object, int n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            int[][] nArrayArray = new int[3][];
            int[] nArray = new int[]{1, 2, 1};
            nArrayArray[0] = nArray;
            nArray = new int[]{2, 4, 2};
            nArrayArray[1] = nArray;
            nArray = new int[]{1, 2, 1};
            nArrayArray[2] = nArray;
            object = nArrayArray;
        }
        if ((n2 & 4) != 0) {
            n = 16;
        }
        ImageUtilsKt.gaussianFilterImg(image, object, n);
    }

    public static final void normalizeHistogramImg(@NotNull Image image, @Nullable Image mask) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (!(image.getColorType() == ImageColorType.GRAY)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] histogram = new int[256];
        Image image2 = mask;
        if (image2 == null) {
            image2 = image;
        }
        Image histogramSrc = image2;
        int n = histogramSrc.getSize();
        for (int i = 0; i < n; ++i) {
            int n2 = histogramSrc.get(i);
            int n3 = histogram[n2];
            histogram[n2] = n3 + 1;
        }
        int[] lookupTable = new int[256];
        double sum = ArraysKt.sum((int[])histogram);
        int acc = 0;
        for (int i = 0; i < 256; ++i) {
            lookupTable[i] = (int)((double)((acc += histogram[i]) * 255) / sum);
        }
        int n4 = image.getWidth();
        for (int x = 0; x < n4; ++x) {
            int n5 = image.getHeight();
            for (int y = 0; y < n5; ++y) {
                image.set(x, y, lookupTable[image.get(x, y)]);
            }
        }
    }

    public static /* synthetic */ void normalizeHistogramImg$default(Image image, Image image2, int n, Object object) {
        if ((n & 2) != 0) {
            image2 = null;
        }
        ImageUtilsKt.normalizeHistogramImg(image, image2);
    }

    @NotNull
    public static final Image createImg(int width, int height, @NotNull ImageColorType type, @NotNull Function2<? super Integer, ? super Integer, Integer> getColorAt) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(getColorAt, (String)"getColorAt");
        int n = 0;
        int n2 = width * height;
        int[] nArray = new int[n2];
        ImageColorType imageColorType = type;
        int n3 = height;
        int n4 = width;
        while (n < n2) {
            int n5 = n++;
            nArray[n5] = ((Number)getColorAt.invoke((Object)(n5 % width), (Object)(n5 / width))).intValue();
        }
        int[] nArray2 = nArray;
        ImageColorType imageColorType2 = imageColorType;
        int n6 = n3;
        int n7 = n4;
        return new Image(n7, n6, imageColorType2, nArray2);
    }

    public static /* synthetic */ Image createImg$default(int n, int n2, ImageColorType imageColorType, Function2 function2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            imageColorType = ImageColorType.RGB;
        }
        return ImageUtilsKt.createImg(n, n2, imageColorType, (Function2<? super Integer, ? super Integer, Integer>)function2);
    }

    @NotNull
    public static final Image resizeImg(@NotNull Image image, int newWidth, int newHeight) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (!(newWidth > 0 && newHeight > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        double scaleX = (double)newWidth / (double)image.getWidth();
        double scaleY = (double)newHeight / (double)image.getHeight();
        return ImageUtilsKt.createImg(newWidth, newHeight, image.getColorType(), (Function2<? super Integer, ? super Integer, Integer>)((Function2)new Function2<Integer, Integer, Integer>(image, scaleX, scaleY){
            final /* synthetic */ Image $image;
            final /* synthetic */ double $scaleX;
            final /* synthetic */ double $scaleY;
            {
                this.$image = $image;
                this.$scaleX = $scaleX;
                this.$scaleY = $scaleY;
                super(2);
            }

            @NotNull
            public final Integer invoke(int x, int y) {
                int ix = Math.min(this.$image.getWidth() - 1, (int)Math.rint((double)x / this.$scaleX));
                int iy = Math.min(this.$image.getHeight() - 1, (int)Math.rint((double)y / this.$scaleY));
                return this.$image.get(ix, iy);
            }
        }));
    }
}

