/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.core.io;

import com.soywiz.korio.net.http.HttpClient;
import com.soywiz.korio.util.checksum.CRC32;
import com.soywiz.korio.util.checksum.SimpleChecksum;
import com.soywiz.korio.util.checksum.SimpleChecksumKt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.iriscan.sdk.io.exception.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/iriscan/sdk/core/io/ResourceHelper;", "", "()V", "client", "Lcom/soywiz/korio/net/http/HttpClient;", "cacheAndGetPath", "", "name", "url", "checksum", "", "cacheAndRead", "", "checkCrc32", "", "bytes", "expected", "read", "readUrl", "biometric-sdk"})
public final class ResourceHelper {
    @NotNull
    private final HttpClient client = HttpClient.Companion.invoke();

    @NotNull
    public final byte[] read(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.readUrl(url);
    }

    @NotNull
    public final byte[] cacheAndRead(@NotNull String name, @NotNull String url, int checksum) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith$default((String)url, (String)"assets://", (boolean)false, (int)2, null)) {
            byte[] bytes2 = this.readUrl(url);
            if (checksum > 0) {
                this.checkCrc32(bytes2, checksum);
            }
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(name);
            Intrinsics.checkNotNull((Object)inputStream);
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            byte[] bytes3 = this.readUrl(url);
            if (checksum > 0) {
                this.checkCrc32(bytes3, checksum);
            }
            Path path = Files.createFile(new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/" + name).toPath(), new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createFile(File(\"${Syste\u2026ric-sdk/$name\").toPath())");
            Path path2 = path;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write(path2, bytes3, Arrays.copyOf(openOptionArray, openOptionArray.length));
            byArray = bytes3;
        }
        return byArray;
    }

    @NotNull
    public final String cacheAndGetPath(@NotNull String name, @NotNull String url, int checksum) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith$default((String)url, (String)"assets://", (boolean)false, (int)2, null)) {
            String path = StringsKt.replace$default((String)url, (String)"assets://", (String)"/", (boolean)false, (int)4, null);
            if (checksum > 0) {
                byte[] bytes2 = this.readUrl(url);
                this.checkCrc32(bytes2, checksum);
            }
            return path;
        }
        Path cachePath = new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/" + name).toPath();
        if (Files.exists(cachePath, new LinkOption[0])) {
            Intrinsics.checkNotNullExpressionValue((Object)cachePath, (String)"cachePath");
            return ((Object)cachePath.toAbsolutePath()).toString();
        }
        byte[] bytes3 = (byte[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, url, null){
            int label;
            final /* synthetic */ ResourceHelper this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpClient.readBytes$default((HttpClient)ResourceHelper.access$getClient$p(this.this$0), (String)this.$url, null, (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (checksum > 0) {
            this.checkCrc32(bytes3, checksum);
        }
        Path path = Files.createFile(new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/" + name).toPath(), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createFile(File(\"${Syste\u2026ric-sdk/$name\").toPath())");
        Path path2 = path;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(path2, bytes3, Arrays.copyOf(openOptionArray, openOptionArray.length));
        return name;
    }

    private final byte[] readUrl(String url) {
        byte[] byArray;
        if (StringsKt.startsWith$default((String)url, (String)"assets://", (boolean)false, (int)2, null)) {
            URL uRL = this.getClass().getResource(StringsKt.replace$default((String)url, (String)"assets://", (String)"/", (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"javaClass.getResource(ur\u2026eplace(\"assets://\", \"/\"))");
            byArray = TextStreamsKt.readBytes((URL)uRL);
        } else if (StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
            byArray = (byte[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, url, null){
                int label;
                final /* synthetic */ ResourceHelper this$0;
                final /* synthetic */ String $url;
                {
                    this.this$0 = $receiver;
                    this.$url = $url;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = HttpClient.readBytes$default((HttpClient)ResourceHelper.access$getClient$p(this.this$0), (String)this.$url, null, (Continuation)((Continuation)this), (int)2, null);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            throw new IllegalArgumentException("Illegal URL: " + url);
        }
        return byArray;
    }

    private final void checkCrc32(byte[] bytes2, int expected) {
        int computedChecksum = SimpleChecksumKt.compute$default((SimpleChecksum)((SimpleChecksum)CRC32.INSTANCE), (byte[])bytes2, (int)0, (int)0, (int)6, null);
        if (computedChecksum != expected) {
            throw new IOException("Invalid data checksum, expected: " + expected + " given: " + computedChecksum, null, 2, null);
        }
    }

    public static final /* synthetic */ HttpClient access$getClient$p(ResourceHelper $this) {
        return $this.client;
    }
}

