/*
 * Decompiled with CFR 0.152.
 */
package net.interus.keycloak.tokencode.jpa.representations;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Date;
import net.interus.keycloak.tokencode.TokenCodeType;
import net.interus.keycloak.tokencode.relay.MediaType;
import org.keycloak.models.utils.KeycloakModelUtils;

public class TokenCodeRepresentation {
    private String id;
    private String realmId;
    private String uri;
    private String fromAddress;
    private String toAddress;
    private String code;
    private String mediaType;
    private String type;
    private String credentialType;
    private String credentialData;
    private String secretData;
    private Date createdAt;
    private Date expiresAt;
    private Boolean confirmed;
    private String byWhom;

    public static TokenCodeRepresentation valueOf(String realmId, String uri, String toAddress, TokenCodeType type, MediaType mediaType, String credentialType, String credentialData) {
        TokenCodeRepresentation tokenCode = new TokenCodeRepresentation();
        tokenCode.id = KeycloakModelUtils.generateId();
        tokenCode.realmId = realmId;
        tokenCode.uri = uri;
        tokenCode.toAddress = toAddress;
        tokenCode.code = type == TokenCodeType.OTP_SAFE ? TokenCodeRepresentation.generateSafeToken() : TokenCodeRepresentation.generateTokenCode();
        tokenCode.type = type.name();
        tokenCode.mediaType = mediaType.name();
        tokenCode.credentialType = credentialType;
        tokenCode.credentialData = credentialData;
        tokenCode.confirmed = false;
        return tokenCode;
    }

    private static String generateTokenCode() {
        SecureRandom secureRandom = new SecureRandom();
        Integer code = secureRandom.nextInt(999999);
        return String.format("%06d", code);
    }

    private static String generateSafeToken() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        String token = encoder.encodeToString(bytes);
        return token;
    }

    public void setSecretData(String secretData) {
        this.secretData = secretData;
    }

    public String getId() {
        return this.id;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getUri() {
        return this.uri;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getCode() {
        return this.code;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getType() {
        return this.type;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getCredentialData() {
        return this.credentialData;
    }

    public String getSecretData() {
        return this.secretData;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public Boolean getConfirmed() {
        return this.confirmed;
    }

    public String getByWhom() {
        return this.byWhom;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCredentialType(String credentialType) {
        this.credentialType = credentialType;
    }

    public void setCredentialData(String credentialData) {
        this.credentialData = credentialData;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setConfirmed(Boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setByWhom(String byWhom) {
        this.byWhom = byWhom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenCodeRepresentation)) {
            return false;
        }
        TokenCodeRepresentation other = (TokenCodeRepresentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$confirmed = this.getConfirmed();
        Boolean other$confirmed = other.getConfirmed();
        if (this$confirmed == null ? other$confirmed != null : !((Object)this$confirmed).equals(other$confirmed)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$realmId = this.getRealmId();
        String other$realmId = other.getRealmId();
        if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$fromAddress = this.getFromAddress();
        String other$fromAddress = other.getFromAddress();
        if (this$fromAddress == null ? other$fromAddress != null : !this$fromAddress.equals(other$fromAddress)) {
            return false;
        }
        String this$toAddress = this.getToAddress();
        String other$toAddress = other.getToAddress();
        if (this$toAddress == null ? other$toAddress != null : !this$toAddress.equals(other$toAddress)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$credentialType = this.getCredentialType();
        String other$credentialType = other.getCredentialType();
        if (this$credentialType == null ? other$credentialType != null : !this$credentialType.equals(other$credentialType)) {
            return false;
        }
        String this$credentialData = this.getCredentialData();
        String other$credentialData = other.getCredentialData();
        if (this$credentialData == null ? other$credentialData != null : !this$credentialData.equals(other$credentialData)) {
            return false;
        }
        String this$secretData = this.getSecretData();
        String other$secretData = other.getSecretData();
        if (this$secretData == null ? other$secretData != null : !this$secretData.equals(other$secretData)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$expiresAt = this.getExpiresAt();
        Date other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        String this$byWhom = this.getByWhom();
        String other$byWhom = other.getByWhom();
        return !(this$byWhom == null ? other$byWhom != null : !this$byWhom.equals(other$byWhom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenCodeRepresentation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $confirmed = this.getConfirmed();
        result = result * 59 + ($confirmed == null ? 43 : ((Object)$confirmed).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $realmId = this.getRealmId();
        result = result * 59 + ($realmId == null ? 43 : $realmId.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $fromAddress = this.getFromAddress();
        result = result * 59 + ($fromAddress == null ? 43 : $fromAddress.hashCode());
        String $toAddress = this.getToAddress();
        result = result * 59 + ($toAddress == null ? 43 : $toAddress.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $credentialType = this.getCredentialType();
        result = result * 59 + ($credentialType == null ? 43 : $credentialType.hashCode());
        String $credentialData = this.getCredentialData();
        result = result * 59 + ($credentialData == null ? 43 : $credentialData.hashCode());
        String $secretData = this.getSecretData();
        result = result * 59 + ($secretData == null ? 43 : $secretData.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        String $byWhom = this.getByWhom();
        result = result * 59 + ($byWhom == null ? 43 : $byWhom.hashCode());
        return result;
    }

    public String toString() {
        return "TokenCodeRepresentation(id=" + this.getId() + ", realmId=" + this.getRealmId() + ", uri=" + this.getUri() + ", fromAddress=" + this.getFromAddress() + ", toAddress=" + this.getToAddress() + ", code=" + this.getCode() + ", mediaType=" + this.getMediaType() + ", type=" + this.getType() + ", credentialType=" + this.getCredentialType() + ", credentialData=" + this.getCredentialData() + ", secretData=" + this.getSecretData() + ", createdAt=" + this.getCreatedAt() + ", expiresAt=" + this.getExpiresAt() + ", confirmed=" + this.getConfirmed() + ", byWhom=" + this.getByWhom() + ")";
    }

    public TokenCodeRepresentation(String id, String realmId, String uri, String fromAddress, String toAddress, String code, String mediaType, String type, String credentialType, String credentialData, String secretData, Date createdAt, Date expiresAt, Boolean confirmed, String byWhom) {
        this.id = id;
        this.realmId = realmId;
        this.uri = uri;
        this.fromAddress = fromAddress;
        this.toAddress = toAddress;
        this.code = code;
        this.mediaType = mediaType;
        this.type = type;
        this.credentialType = credentialType;
        this.credentialData = credentialData;
        this.secretData = secretData;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.confirmed = confirmed;
        this.byWhom = byWhom;
    }

    public TokenCodeRepresentation() {
    }
}

