/*
 * Decompiled with CFR 0.152.
 */
package net.interus.keycloak.tokencode.integrated.firebase;

import org.keycloak.Config;

public class DynamicLinksProperties {
    public static final String DYNAMIC_LINKS_API_HOST = "FIREBASE_DYNAMIC_LINKS_API_HOST";
    public static final String DYNAMIC_LINKS_API_VERSION = "FIREBASE_DYNAMIC_LINKS_API_VERSION";
    public static final String DYNAMIC_LINKS_API_KEY = "FIREBASE_DYNAMIC_LINKS_API_KEY";
    static String defaultApiHost = System.getenv("FIREBASE_DYNAMIC_LINKS_API_HOST");
    static String defaultApiVersion = System.getenv("FIREBASE_DYNAMIC_LINKS_API_VERSION");
    static String defaultApiKey = System.getenv("FIREBASE_DYNAMIC_LINKS_API_KEY");
    String apiHost;
    String apiVersion;
    String apiKey;

    public static DynamicLinksProperties valueOf(Config.Scope config) {
        return DynamicLinksProperties.builder().apiHost(config.get(DYNAMIC_LINKS_API_HOST, defaultApiHost)).apiVersion(config.get(DYNAMIC_LINKS_API_VERSION, defaultApiVersion)).apiKey(config.get(DYNAMIC_LINKS_API_KEY, defaultApiKey)).build();
    }

    public static DynamicLinksProperties defaultValueOf() {
        return DynamicLinksProperties.builder().apiHost(defaultApiHost).apiVersion(defaultApiVersion).apiKey(defaultApiKey).build();
    }

    DynamicLinksProperties(String apiHost, String apiVersion, String apiKey) {
        this.apiHost = apiHost;
        this.apiVersion = apiVersion;
        this.apiKey = apiKey;
    }

    public static DynamicLinksPropertiesBuilder builder() {
        return new DynamicLinksPropertiesBuilder();
    }

    public static class DynamicLinksPropertiesBuilder {
        private String apiHost;
        private String apiVersion;
        private String apiKey;

        DynamicLinksPropertiesBuilder() {
        }

        public DynamicLinksPropertiesBuilder apiHost(String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public DynamicLinksPropertiesBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DynamicLinksPropertiesBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public DynamicLinksProperties build() {
            return new DynamicLinksProperties(this.apiHost, this.apiVersion, this.apiKey);
        }

        public String toString() {
            return "DynamicLinksProperties.DynamicLinksPropertiesBuilder(apiHost=" + this.apiHost + ", apiVersion=" + this.apiVersion + ", apiKey=" + this.apiKey + ")";
        }
    }
}

