/*
 * Decompiled with CFR 0.152.
 */
package net.interus.keycloak.tokencode.relay;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.interus.keycloak.tokencode.relay.Link;
import net.interus.keycloak.tokencode.util.URLShorter;

public class Message {
    private String principal;
    private String topic;
    private String title;
    private String summary;
    private String body;
    private String image;
    private String template;
    private Link link;
    private Map<String, String> data;
    private Boolean posting;
    private Map<String, String> dictionary;

    public Message clearDictionary() {
        if (this.dictionary != null) {
            this.dictionary.clear();
        }
        this.dictionary = null;
        return this;
    }

    public Message putDictionary(String regex, String replacement) {
        if (this.dictionary == null) {
            this.dictionary = new HashMap<String, String>();
        }
        if (regex != null && replacement != null) {
            this.dictionary.put(regex, replacement);
        }
        return this;
    }

    public Message macro() {
        if (this.dictionary != null) {
            this.dictionary.keySet().stream().forEach(regex -> {
                String replacement = this.dictionary.get(regex);
                if (this.title != null) {
                    this.title = this.title.replace((CharSequence)regex, replacement);
                }
                if (this.summary != null) {
                    this.summary = this.summary.replace((CharSequence)regex, replacement);
                }
                if (this.body != null) {
                    this.body = this.body.replace((CharSequence)regex, replacement);
                }
                if (this.link != null) {
                    this.link = this.link.replaceAll((CharSequence)regex, replacement);
                }
            });
        }
        return this;
    }

    public boolean hasBodyLink() {
        return this.body != null ? this.body.contains("$link.url") : false;
    }

    public Message encodeUrlBody() {
        if (this.body != null) {
            try {
                String url;
                int start;
                while ((start = this.body.indexOf("https://")) > 0) {
                    int end = this.body.indexOf(" ", start) > 0 ? this.body.indexOf(" ", start) : this.body.length();
                    url = this.body.substring(start, end);
                    String encoded = URLEncoder.encode(url, "UTF-8");
                    this.body = this.body.replace(url, encoded);
                }
                while ((start = this.body.indexOf("http://")) > 0) {
                    int spaceEnd = this.body.indexOf(" ", start);
                    int enterEnd = this.body.indexOf("\n", start);
                    int end = spaceEnd > 0 && enterEnd > 0 ? Math.min(spaceEnd, enterEnd) : (spaceEnd > 0 ? spaceEnd : (enterEnd > 0 ? enterEnd : this.body.length()));
                    url = this.body.substring(start, end);
                    String encoded = URLEncoder.encode(url, "UTF-8");
                    this.body = this.body.replace(url, encoded);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Message shortUrlBody() {
        if (this.body != null) {
            try {
                int start;
                while ((start = this.body.indexOf("https://avkd.page.link")) > 0) {
                    int spaceEnd = this.body.indexOf(" ", start);
                    int enterEnd = this.body.indexOf("\n", start);
                    int end = spaceEnd > 0 && enterEnd > 0 ? Math.min(spaceEnd, enterEnd) : (spaceEnd > 0 ? spaceEnd : (enterEnd > 0 ? enterEnd : this.body.length()));
                    String url = this.body.substring(start, end);
                    String shortened = URLShorter.shorten(url);
                    if (shortened != null) {
                        this.body = this.body.replace(url, shortened);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getBody() {
        return this.body;
    }

    public String getImage() {
        return this.image;
    }

    public String getTemplate() {
        return this.template;
    }

    public Link getLink() {
        return this.link;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public Boolean getPosting() {
        return this.posting;
    }

    public Map<String, String> getDictionary() {
        return this.dictionary;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public void setPosting(Boolean posting) {
        this.posting = posting;
    }

    public void setDictionary(Map<String, String> dictionary) {
        this.dictionary = dictionary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$posting = this.getPosting();
        Boolean other$posting = other.getPosting();
        if (this$posting == null ? other$posting != null : !((Object)this$posting).equals(other$posting)) {
            return false;
        }
        String this$principal = this.getPrincipal();
        String other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        Map<String, String> this$data = this.getData();
        Map<String, String> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Map<String, String> this$dictionary = this.getDictionary();
        Map<String, String> other$dictionary = other.getDictionary();
        return !(this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $posting = this.getPosting();
        result = result * 59 + ($posting == null ? 43 : ((Object)$posting).hashCode());
        String $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        Map<String, String> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Map<String, String> $dictionary = this.getDictionary();
        result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
        return result;
    }

    public String toString() {
        return "Message(principal=" + this.getPrincipal() + ", topic=" + this.getTopic() + ", title=" + this.getTitle() + ", summary=" + this.getSummary() + ", body=" + this.getBody() + ", image=" + this.getImage() + ", template=" + this.getTemplate() + ", link=" + this.getLink() + ", data=" + this.getData() + ", posting=" + this.getPosting() + ", dictionary=" + this.getDictionary() + ")";
    }

    public Message() {
    }

    public Message(String principal, String topic, String title, String summary, String body, String image, String template, Link link, Map<String, String> data, Boolean posting, Map<String, String> dictionary) {
        this.principal = principal;
        this.topic = topic;
        this.title = title;
        this.summary = summary;
        this.body = body;
        this.image = image;
        this.template = template;
        this.link = link;
        this.data = data;
        this.posting = posting;
        this.dictionary = dictionary;
    }

    public static class MessageBuilder {
        private String principal;
        private String topic;
        private String title;
        private String summary;
        private String body;
        private String image;
        private String template;
        private Link link;
        private Map<String, String> data;
        private Boolean posting;
        private Map<String, String> dictionary;

        MessageBuilder() {
        }

        public MessageBuilder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public MessageBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public MessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public MessageBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public MessageBuilder body(String body) {
            this.body = body;
            return this;
        }

        public MessageBuilder image(String image) {
            this.image = image;
            return this;
        }

        public MessageBuilder template(String template) {
            this.template = template;
            return this;
        }

        public MessageBuilder link(Link link) {
            this.link = link;
            return this;
        }

        public MessageBuilder data(Map<String, String> data) {
            this.data = data;
            return this;
        }

        public MessageBuilder posting(Boolean posting) {
            this.posting = posting;
            return this;
        }

        public MessageBuilder dictionary(Map<String, String> dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public Message build() {
            return new Message(this.principal, this.topic, this.title, this.summary, this.body, this.image, this.template, this.link, this.data, this.posting, this.dictionary);
        }

        public String toString() {
            return "Message.MessageBuilder(principal=" + this.principal + ", topic=" + this.topic + ", title=" + this.title + ", summary=" + this.summary + ", body=" + this.body + ", image=" + this.image + ", template=" + this.template + ", link=" + this.link + ", data=" + this.data + ", posting=" + this.posting + ", dictionary=" + this.dictionary + ")";
        }
    }
}

