/*
 * Decompiled with CFR 0.152.
 */
package net.interus.keycloak.tokencode.relay;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.interus.keycloak.tokencode.relay.Button;
import net.interus.keycloak.tokencode.util.URLShorter;

public class Link {
    private String url;
    private String fallback;
    private String app;
    private Button button;

    public Link replaceAll(CharSequence regex, CharSequence replacement) {
        if (this.url != null) {
            this.url = this.url.replace(regex, replacement);
        }
        if (this.fallback != null) {
            this.fallback = this.fallback.replace(regex, replacement);
        }
        if (this.app != null) {
            this.app = this.app.replace(regex, replacement);
        }
        return this;
    }

    public Link encodeFallbackAndApp() {
        if (this.fallback != null) {
            try {
                this.fallback = URLEncoder.encode(this.fallback, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (this.app != null) {
            try {
                this.app = URLEncoder.encode(this.app, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Link fillFallbackAndAppToUrl() {
        if (this.url != null) {
            if (this.fallback != null) {
                this.url = this.url.replace("$fallback", this.fallback);
            }
            if (this.app != null) {
                this.url = this.url.replace("$app", this.app);
            }
        }
        return this;
    }

    public Link shortenUrl() {
        if (this.url != null && this.url.contains("https://avkd.page.link")) {
            try {
                String shortened = URLShorter.shorten(this.url);
                if (shortened != null) {
                    this.url = shortened;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public boolean hasButton() {
        return this.button != null;
    }

    public static LinkBuilder builder() {
        return new LinkBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getFallback() {
        return this.fallback;
    }

    public String getApp() {
        return this.app;
    }

    public Button getButton() {
        return this.button;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setButton(Button button) {
        this.button = button;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$fallback = this.getFallback();
        String other$fallback = other.getFallback();
        if (this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        Button this$button = this.getButton();
        Button other$button = other.getButton();
        return !(this$button == null ? other$button != null : !((Object)this$button).equals(other$button));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Link;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        Button $button = this.getButton();
        result = result * 59 + ($button == null ? 43 : ((Object)$button).hashCode());
        return result;
    }

    public String toString() {
        return "Link(url=" + this.getUrl() + ", fallback=" + this.getFallback() + ", app=" + this.getApp() + ", button=" + this.getButton() + ")";
    }

    public Link() {
    }

    public Link(String url, String fallback, String app, Button button) {
        this.url = url;
        this.fallback = fallback;
        this.app = app;
        this.button = button;
    }

    public static class LinkBuilder {
        private String url;
        private String fallback;
        private String app;
        private Button button;

        LinkBuilder() {
        }

        public LinkBuilder url(String url) {
            this.url = url;
            return this;
        }

        public LinkBuilder fallback(String fallback) {
            this.fallback = fallback;
            return this;
        }

        public LinkBuilder app(String app) {
            this.app = app;
            return this;
        }

        public LinkBuilder button(Button button) {
            this.button = button;
            return this;
        }

        public Link build() {
            return new Link(this.url, this.fallback, this.app, this.button);
        }

        public String toString() {
            return "Link.LinkBuilder(url=" + this.url + ", fallback=" + this.fallback + ", app=" + this.app + ", button=" + this.button + ")";
        }
    }
}

