/*
 * Decompiled with CFR 0.152.
 */
package net.interus.keycloak.tokencode;

import org.keycloak.Config;

public class TokenCodeProperties {
    public static final String TOKEN_SMS_SENDER_ID = "TOKEN_SMS_SENDER_ID";
    public static final String TOKEN_PUSH_NOTIFICATION_SENDER_ID = "TOKEN_PUSH_NOTIFICATION_SENDER_ID";
    public static final String TOKEN_BIZTALK_SENDER_ID = "TOKEN_BIZTALK_SENDER_ID";
    public static final String EXPIRES_IN = "TOKEN_EXPIRES_IN";
    public static final String HOUR_MAXIMUM = "TOKEN_HOUR_MAXIMUM";
    static String defaultSmsSenderId = System.getenv("TOKEN_SMS_SENDER_ID");
    static String defaultPushNotificationSenderId = System.getenv("TOKEN_PUSH_NOTIFICATION_SENDER_ID");
    static String defaultBiztalkSenderId = System.getenv("TOKEN_BIZTALK_SENDER_ID");
    static Integer defaultExpiresIn = TokenCodeProperties.parseIntegerSafety(System.getenv("TOKEN_EXPIRES_IN"));
    static Integer defaultHourMaximum = TokenCodeProperties.parseIntegerSafety(System.getenv("TOKEN_HOUR_MAXIMUM"));
    String smsSenderId;
    String pushNotificationSenderId;
    String biztalkSenderId;
    Integer expiresIn;
    Integer hourMaximum;

    public static TokenCodeProperties valueOf(Config.Scope config) {
        return TokenCodeProperties.builder().smsSenderId(config.get(TOKEN_SMS_SENDER_ID, defaultSmsSenderId)).pushNotificationSenderId(config.get(TOKEN_PUSH_NOTIFICATION_SENDER_ID, defaultPushNotificationSenderId)).biztalkSenderId(config.get(TOKEN_BIZTALK_SENDER_ID, defaultBiztalkSenderId)).expiresIn(config.getInt(EXPIRES_IN, defaultExpiresIn)).hourMaximum(config.getInt(HOUR_MAXIMUM, defaultHourMaximum)).build();
    }

    public static Integer parseIntegerSafety(String text) {
        if (text == null) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Boolean parseBooleanSafety(String text) {
        if (text == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    TokenCodeProperties(String smsSenderId, String pushNotificationSenderId, String biztalkSenderId, Integer expiresIn, Integer hourMaximum) {
        this.smsSenderId = smsSenderId;
        this.pushNotificationSenderId = pushNotificationSenderId;
        this.biztalkSenderId = biztalkSenderId;
        this.expiresIn = expiresIn;
        this.hourMaximum = hourMaximum;
    }

    public static TokenCodePropertiesBuilder builder() {
        return new TokenCodePropertiesBuilder();
    }

    public String getSmsSenderId() {
        return this.smsSenderId;
    }

    public String getPushNotificationSenderId() {
        return this.pushNotificationSenderId;
    }

    public String getBiztalkSenderId() {
        return this.biztalkSenderId;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public Integer getHourMaximum() {
        return this.hourMaximum;
    }

    public void setSmsSenderId(String smsSenderId) {
        this.smsSenderId = smsSenderId;
    }

    public void setPushNotificationSenderId(String pushNotificationSenderId) {
        this.pushNotificationSenderId = pushNotificationSenderId;
    }

    public void setBiztalkSenderId(String biztalkSenderId) {
        this.biztalkSenderId = biztalkSenderId;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setHourMaximum(Integer hourMaximum) {
        this.hourMaximum = hourMaximum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenCodeProperties)) {
            return false;
        }
        TokenCodeProperties other = (TokenCodeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$expiresIn = this.getExpiresIn();
        Integer other$expiresIn = other.getExpiresIn();
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        Integer this$hourMaximum = this.getHourMaximum();
        Integer other$hourMaximum = other.getHourMaximum();
        if (this$hourMaximum == null ? other$hourMaximum != null : !((Object)this$hourMaximum).equals(other$hourMaximum)) {
            return false;
        }
        String this$smsSenderId = this.getSmsSenderId();
        String other$smsSenderId = other.getSmsSenderId();
        if (this$smsSenderId == null ? other$smsSenderId != null : !this$smsSenderId.equals(other$smsSenderId)) {
            return false;
        }
        String this$pushNotificationSenderId = this.getPushNotificationSenderId();
        String other$pushNotificationSenderId = other.getPushNotificationSenderId();
        if (this$pushNotificationSenderId == null ? other$pushNotificationSenderId != null : !this$pushNotificationSenderId.equals(other$pushNotificationSenderId)) {
            return false;
        }
        String this$biztalkSenderId = this.getBiztalkSenderId();
        String other$biztalkSenderId = other.getBiztalkSenderId();
        return !(this$biztalkSenderId == null ? other$biztalkSenderId != null : !this$biztalkSenderId.equals(other$biztalkSenderId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenCodeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        Integer $hourMaximum = this.getHourMaximum();
        result = result * 59 + ($hourMaximum == null ? 43 : ((Object)$hourMaximum).hashCode());
        String $smsSenderId = this.getSmsSenderId();
        result = result * 59 + ($smsSenderId == null ? 43 : $smsSenderId.hashCode());
        String $pushNotificationSenderId = this.getPushNotificationSenderId();
        result = result * 59 + ($pushNotificationSenderId == null ? 43 : $pushNotificationSenderId.hashCode());
        String $biztalkSenderId = this.getBiztalkSenderId();
        result = result * 59 + ($biztalkSenderId == null ? 43 : $biztalkSenderId.hashCode());
        return result;
    }

    public String toString() {
        return "TokenCodeProperties(smsSenderId=" + this.getSmsSenderId() + ", pushNotificationSenderId=" + this.getPushNotificationSenderId() + ", biztalkSenderId=" + this.getBiztalkSenderId() + ", expiresIn=" + this.getExpiresIn() + ", hourMaximum=" + this.getHourMaximum() + ")";
    }

    public static class TokenCodePropertiesBuilder {
        private String smsSenderId;
        private String pushNotificationSenderId;
        private String biztalkSenderId;
        private Integer expiresIn;
        private Integer hourMaximum;

        TokenCodePropertiesBuilder() {
        }

        public TokenCodePropertiesBuilder smsSenderId(String smsSenderId) {
            this.smsSenderId = smsSenderId;
            return this;
        }

        public TokenCodePropertiesBuilder pushNotificationSenderId(String pushNotificationSenderId) {
            this.pushNotificationSenderId = pushNotificationSenderId;
            return this;
        }

        public TokenCodePropertiesBuilder biztalkSenderId(String biztalkSenderId) {
            this.biztalkSenderId = biztalkSenderId;
            return this;
        }

        public TokenCodePropertiesBuilder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public TokenCodePropertiesBuilder hourMaximum(Integer hourMaximum) {
            this.hourMaximum = hourMaximum;
            return this;
        }

        public TokenCodeProperties build() {
            return new TokenCodeProperties(this.smsSenderId, this.pushNotificationSenderId, this.biztalkSenderId, this.expiresIn, this.hourMaximum);
        }

        public String toString() {
            return "TokenCodeProperties.TokenCodePropertiesBuilder(smsSenderId=" + this.smsSenderId + ", pushNotificationSenderId=" + this.pushNotificationSenderId + ", biztalkSenderId=" + this.biztalkSenderId + ", expiresIn=" + this.expiresIn + ", hourMaximum=" + this.hourMaximum + ")";
        }
    }
}

