/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.typedkey;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.infumia.frame.typedkey.TypedKey;
import net.infumia.frame.typedkey.TypedKeyStorage;
import net.infumia.frame.typedkey.TypedKeyStorageImmutableImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypedKeyStorageImpl
extends TypedKeyStorageImmutableImpl
implements TypedKeyStorage {
    TypedKeyStorageImpl(@NotNull Map<TypedKey<?>, Object> map) {
        super(map);
    }

    @Override
    public <T> boolean put(@NotNull TypedKey<T> key, @NotNull T value) {
        return this.map.put(key, value) == null;
    }

    @Override
    @NotNull
    public <T> T compute(@NotNull TypedKey<T> key, @NotNull Function<@Nullable T, T> oldValueToNewValue) {
        return (T)this.map.compute(key, (? super K __, ? super V oldValue) -> {
            if (oldValue == null) {
                return oldValueToNewValue.apply(null);
            }
            return oldValueToNewValue.apply(oldValue);
        });
    }

    @Override
    @NotNull
    public <T> T computeIfAbsent(@NotNull TypedKey<T> key, @NotNull Supplier<T> valueSupplier) {
        return (T)this.map.computeIfAbsent(key, (? super K __) -> valueSupplier.get());
    }

    @Override
    @Nullable
    public <T> T computeIfPresent(@NotNull TypedKey<T> key, @NotNull Function<T, T> oldValueToNewValue) {
        return (T)this.map.computeIfPresent(key, (? super K __, ? super V oldValue) -> oldValueToNewValue.apply(oldValue));
    }

    @Override
    public <T> boolean remove(@NotNull TypedKey<T> key) {
        return this.map.remove(key) != null;
    }

    @Override
    public String toString() {
        return "TypedKeyStorageImpl{map=" + this.map + '}';
    }
}

