/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.typedkey;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.infumia.frame.Preconditions;
import net.infumia.frame.typedkey.TypedKey;
import net.infumia.frame.typedkey.TypedKeyStorageImmutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

class TypedKeyStorageImmutableImpl
implements TypedKeyStorageImmutable {
    @NotNull
    protected final Map<TypedKey<?>, Object> map;

    TypedKeyStorageImmutableImpl(@NotNull Map<TypedKey<?>, Object> map) {
        this.map = map;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull TypedKey<T> key) {
        return (T)this.map.get(key);
    }

    @Override
    @Nullable
    public Object get(@NotNull String key) {
        return this.map.keySet().stream().filter(k -> k.key().equals(key)).findFirst().map(this::get).orElse(null);
    }

    @Override
    @Nullable
    public <T> T getUnchecked(@NotNull String key) {
        return this.map.keySet().stream().filter(k -> k.key().equals(key)).findFirst().map(this::get).orElse(null);
    }

    @Override
    @NotNull
    public <T> T getOrThrow(@NotNull TypedKey<T> key) {
        return Preconditions.argumentNotNull(this.get(key), "Key '%s' not found!", key);
    }

    @Override
    public <T> T getOrDefault(@NotNull TypedKey<T> key, @Nullable T defaultValue) {
        T value = this.get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    @NotNull
    public Object getOrThrow(@NotNull String key) {
        return Preconditions.argumentNotNull(this.get(key), "Key '%s' not found!", key);
    }

    @Override
    public Object getOrDefault(@NotNull String key, @Nullable Object defaultValue) {
        Object value = this.get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    @NotNull
    public <T> T getUncheckedOrThrow(@NotNull String key) {
        return Preconditions.argumentNotNull(this.getUnchecked(key), "Key '%s' not found!", key);
    }

    @Override
    public boolean contains(@NotNull TypedKey<?> key) {
        return this.map.containsKey(key);
    }

    @Override
    @NotNull
    public Collection<TypedKey<?>> keys() {
        return Collections.unmodifiableCollection(this.map.keySet());
    }

    @Override
    @NotNull
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    @NotNull
    public Collection<Map.Entry<TypedKey<?>, Object>> entries() {
        return Collections.unmodifiableCollection(this.map.entrySet());
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<TypedKey<?>, Object> map() {
        return Collections.unmodifiableMap(this.map);
    }

    public String toString() {
        return "TypedKeyStorageImmutableImpl{map=" + this.map + '}';
    }
}

