/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.typedkey;

import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TypedKey<T> {
    private final TypeToken<T> cls;
    private final String key;

    private TypedKey(@NotNull TypeToken<T> cls, @NotNull String key) {
        this.cls = cls;
        this.key = key;
    }

    @NotNull
    public static <T> TypedKey<T> of(@NotNull TypeToken<T> type, @NotNull String key) {
        return new TypedKey<T>(type, key);
    }

    @NotNull
    public static <T> TypedKey<T> of(@NotNull Class<T> cls, @NotNull String key) {
        return TypedKey.of(TypeToken.get(cls), key);
    }

    @NotNull
    public TypeToken<T> cls() {
        return this.cls;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedKey key1 = (TypedKey)o;
        return Objects.equals(this.key, key1.key);
    }

    public String toString() {
        return "TypedKey{cls=" + this.cls + ", key='" + this.key + '\'' + '}';
    }
}

