/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame;

import java.lang.reflect.Field;
import net.infumia.frame.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Reflection {
    public static boolean hasClass(@NotNull String className) {
        return Reflection.findClass(className) != null;
    }

    @Nullable
    public static Class<?> findClass(@NotNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static <T> T findInstanceFromField(@NotNull String className, @NotNull String fieldName) {
        Class<?> cls = Preconditions.argumentNotNull(Reflection.findClass(className), "Class '%s' not found", className);
        Field field = null;
        boolean old = false;
        try {
            field = cls.getDeclaredField(fieldName);
            old = field.isAccessible();
            field.setAccessible(true);
            Object object = Preconditions.argumentNotNull(field.get(null), "Field '%s' value is null in class '%s'!", fieldName, className);
            return (T)object;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Field '%s' not found in class '%s'!", fieldName, className), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Cannot access to field '%s' in class '%s'!", fieldName, className), e);
        }
        finally {
            if (field != null) {
                field.setAccessible(old);
            }
        }
    }

    private Reflection() {
        throw new IllegalStateException("Utility class!");
    }
}

