/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Utilities {
    private static final char[] HEX_CODES = "0123456789abcdef".toCharArray();

    private Utilities() {
    }

    public static String singleQuote(String other) {
        return "'" + other + "'";
    }

    public static String toHex(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(HEX_CODES[b >> 4 & 0xF]);
            r.append(HEX_CODES[b & 0xF]);
        }
        return r.toString();
    }

    public static <T, S> List<S> map(List<T> data, Function<T, S> function) {
        ArrayList<S> result = new ArrayList<S>(data.size());
        for (T datum : data) {
            result.add(function.apply(datum));
        }
        return result;
    }

    public static <T, S> List<S> flatMap(List<T> data, Function<T, List<S>> function) {
        ArrayList result = new ArrayList(data.size());
        for (T datum : data) {
            result.addAll(function.apply(datum));
        }
        return result;
    }
}

