/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.sqllogictest.SqlTestQuery;
import net.hydromatic.sqllogictest.util.StringPrintStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TestStatistics {
    static final DecimalFormat DF = new DecimalFormat("#,###");
    private int failedTestCount;
    private int passedTestCount;
    private int ignoredTestCount;
    private int filesNotParsed;
    private int testFiles;
    private int verbosity;
    final List<FailedTestDescription> failures = new ArrayList<FailedTestDescription>();
    final boolean stopAtFirstErrror;

    public int getTestFileCount() {
        return this.testFiles;
    }

    public int getParseFailureCount() {
        return this.filesNotParsed;
    }

    public void incFilesNotParsed() {
        ++this.filesNotParsed;
    }

    public void incFiles() {
        ++this.testFiles;
    }

    public void incPassed() {
        ++this.passedTestCount;
    }

    public void incIgnored() {
        ++this.ignoredTestCount;
    }

    public void setPassedTestCount(int n) {
        this.passedTestCount = n;
    }

    public void setFailedTestCount(int n) {
        this.failedTestCount = n;
    }

    public void setIgnoredTestCount(int n) {
        this.ignoredTestCount = n;
    }

    public void add(TestStatistics stats) {
        this.failedTestCount += stats.failedTestCount;
        this.passedTestCount += stats.passedTestCount;
        this.ignoredTestCount += stats.ignoredTestCount;
        this.filesNotParsed += stats.filesNotParsed;
        this.testFiles += stats.testFiles;
        this.verbosity = Math.max(this.verbosity, stats.verbosity);
        this.failures.addAll(stats.failures);
    }

    public int getFailedTestCount() {
        return this.failedTestCount;
    }

    public int getPassedTestCount() {
        return this.passedTestCount;
    }

    public int getIgnoredTestCount() {
        return this.ignoredTestCount;
    }

    public TestStatistics(boolean stopAtFirstError, int verbosity) {
        this.stopAtFirstErrror = stopAtFirstError;
        this.verbosity = verbosity;
        this.failedTestCount = 0;
        this.passedTestCount = 0;
        this.ignoredTestCount = 0;
        this.filesNotParsed = 0;
        this.testFiles = 0;
    }

    public boolean addFailure(FailedTestDescription failure) {
        this.failures.add(failure);
        ++this.failedTestCount;
        return this.stopAtFirstErrror;
    }

    public int totalTests() {
        return this.passedTestCount + this.ignoredTestCount + this.failedTestCount;
    }

    public void printStatistics(PrintStream out) {
        out.println("Total files processed: " + DF.format(this.testFiles));
        out.println("Files not parsed: " + DF.format(this.filesNotParsed));
        out.println("Passed: " + DF.format(this.passedTestCount));
        out.println("Failed: " + DF.format(this.failedTestCount));
        out.println("Ignored: " + DF.format(this.ignoredTestCount));
        if (!this.failures.isEmpty()) {
            out.print(this.failures.size());
            out.println(" failures:");
        }
        for (FailedTestDescription failure : this.failures) {
            out.println(failure.toString(this.verbosity));
        }
    }

    public static class FailedTestDescription {
        public final SqlTestQuery query;
        public final @Nullable String error;
        public final String details;
        public final @Nullable Throwable exception;

        public FailedTestDescription(SqlTestQuery query, @Nullable String error, String details, @Nullable Throwable exception) {
            this.query = query;
            if (error == null && exception != null && (error = exception.getMessage()) == null) {
                error = "Exception " + exception.getClass().getSimpleName();
            }
            this.error = error;
            this.details = details;
            this.exception = exception;
        }

        public String toString(int verbosity) {
            StackTraceElement[] stackTrace;
            String result = "ERROR: " + (this.error != null ? this.error : "") + System.lineSeparator() + "\ttest: " + this.query.file + ":" + this.query.line + System.lineSeparator() + "\t" + this.query;
            if (verbosity > 0 && this.exception != null && (stackTrace = this.exception.getStackTrace()).length > 0) {
                StackTraceElement el = stackTrace[0];
                result = result + System.lineSeparator() + el.getFileName() + ":" + el.getLineNumber() + " " + el.getClassName() + "." + el.getMethodName();
            }
            if (this.exception != null && verbosity > 1) {
                if (!this.details.isEmpty()) {
                    result = result + System.lineSeparator() + this.details;
                }
                StringPrintStream str = new StringPrintStream();
                this.exception.printStackTrace(str.getPrintStream());
                result = result + System.lineSeparator() + str;
            }
            return result;
        }

        public String toString() {
            return this.toString(1);
        }
    }
}

