/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.hydromatic.sqllogictest.executors.SqlSltTestExecutor;
import net.hydromatic.sqllogictest.util.Utilities;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OptionsParser {
    final Map<String, OptionDescription> knownOptions = new HashMap<String, OptionDescription>();
    final List<String> optionOrder;
    final SuppliedOptions options;

    public SuppliedOptions getOptions() {
        return this.options;
    }

    public void setBinaryName(String binaryName) {
        this.options.binaryName = binaryName;
    }

    public OptionsParser(boolean exit, PrintStream out, PrintStream err) {
        this.options = new SuppliedOptions(exit, out, err);
        this.optionOrder = new ArrayList<String>();
        this.registerDefaultOptions();
    }

    void registerDefaultOptions() {
        this.registerOption("-h", null, "Show this help message and exit", o -> false);
        this.registerOption("-x", null, "Stop at the first encountered query error", o -> {
            this.options.stopAtFirstError = true;
            return true;
        });
        this.registerOption("-n", null, "Do not execute, just parse the test files", o -> {
            this.options.doNotExecute = true;
            return true;
        });
        this.registerOption("-e", "executor", "Executor to use", this.options::setExecutor);
        this.registerOption("-b", "filename", "Load a list of buggy commands to skip from this file", this.options::setBugsFile);
        this.registerOption("-v", null, "Increase verbosity (can be repeated)", o -> {
            ++this.options.verbosity;
            return true;
        });
    }

    public void registerOption(String option, @Nullable String argName, String description, Function<String, Boolean> optionArgProcessor) {
        OptionDescription o = new OptionDescription(option, argName, description, optionArgProcessor);
        if (this.knownOptions.containsKey(option)) {
            this.options.error("Option " + Utilities.singleQuote(option) + " already registered");
            return;
        }
        this.optionOrder.add(option);
        this.knownOptions.put(option, o);
    }

    public SuppliedOptions parse(String ... argv) {
        if (argv.length == 0) {
            return this.options.abort("No arguments to process");
        }
        for (int i = 0; i < argv.length; ++i) {
            boolean success;
            String opt = argv[i];
            String arg = null;
            OptionDescription option = null;
            if (opt.startsWith("--")) {
                option = this.knownOptions.get(opt);
                if (option == null) {
                    return this.options.abort("Unknown option " + Utilities.singleQuote(opt));
                }
            } else if (opt.startsWith("-")) {
                option = this.knownOptions.get(opt);
                if (option == null && opt.length() > 2) {
                    arg = opt.substring(2);
                    opt = opt.substring(0, 2);
                    option = this.knownOptions.get(opt);
                }
                if (option == null) {
                    return this.options.abort("Unknown option " + Utilities.singleQuote(opt));
                }
            }
            if (option == null) {
                this.options.directories.add(opt);
                continue;
            }
            if (option.argName != null && arg == null) {
                if (i == argv.length - 1) {
                    return this.options.abort("Option " + Utilities.singleQuote(opt) + " is missing required argument " + option.argName);
                }
                arg = argv[++i];
            }
            if (success = option.optionArgProcessor.apply(arg).booleanValue()) continue;
            return this.options.abort(null);
        }
        return this.options;
    }

    public void registerExecutor(String executorName, Supplier<SqlSltTestExecutor> executor) {
        this.options.registerExecutor(executorName, executor);
    }

    void usage() {
        this.options.out.println(this.options.binaryName + " [options] files_or_directories_with_tests");
        this.options.out.println("Executes the SQL Logic Tests using a SQL execution engine");
        this.options.out.println("See https://www.sqlite.org/sqllogictest/doc/trunk/about.wiki");
        this.options.out.println("Options:");
        int labelLen = 0;
        for (String o : this.optionOrder) {
            int len = o.length();
            OptionDescription option = this.knownOptions.get(o);
            if (option.argName != null) {
                len += 1 + option.argName.length();
            }
            if (labelLen >= len) continue;
            labelLen = len;
        }
        labelLen += 3;
        for (String o : this.optionOrder) {
            OptionDescription option = this.knownOptions.get(o);
            int len = o.length();
            this.options.out.print(option.option);
            if (option.argName != null) {
                this.options.out.print(" " + option.argName);
                len += 1 + option.argName.length();
            }
            for (String line : option.description.split("\n")) {
                for (int i = 0; i < labelLen - len; ++i) {
                    this.options.out.print(" ");
                }
                this.options.out.println(line);
                len = 0;
            }
        }
        this.options.out.println("Registered executors:");
        for (String e : this.options.executorFactories.keySet()) {
            this.options.out.println("\t" + e);
        }
    }

    static class OptionDescription {
        final String option;
        final @Nullable String argName;
        final String description;
        final Function<String, Boolean> optionArgProcessor;

        OptionDescription(String option, @Nullable String argName, String description, Function<String, Boolean> optionArgProcessor) {
            this.option = option;
            this.argName = argName;
            this.description = description;
            this.optionArgProcessor = optionArgProcessor;
        }
    }

    public final class SuppliedOptions {
        public int exitCode = 0;
        String binaryName;
        final List<String> directories;
        public final PrintStream out;
        public final PrintStream err;
        public boolean stopAtFirstError = false;
        public boolean doNotExecute = false;
        public String executor = "";
        public String bugsFile = "";
        public int verbosity = 0;
        final Map<String, Supplier<SqlSltTestExecutor>> executorFactories;
        final boolean exit;

        SuppliedOptions(boolean exit, PrintStream out, PrintStream err) {
            this.exit = exit;
            this.executorFactories = new HashMap<String, Supplier<SqlSltTestExecutor>>();
            this.directories = new ArrayList<String>();
            this.out = out;
            this.err = err;
        }

        SuppliedOptions abort(boolean abort, @Nullable String message) {
            this.exitCode = 1;
            if (message != null) {
                this.err.println(message);
            }
            OptionsParser.this.usage();
            if (abort) {
                System.exit(1);
            }
            return this;
        }

        public List<String> getDirectories() {
            if (this.directories.isEmpty()) {
                this.directories.add("test");
            }
            return this.directories;
        }

        boolean setExecutor(String executor) {
            if (!this.executor.isEmpty()) {
                this.err.println("Executor already set to " + this.executor);
                return false;
            }
            this.executor = executor;
            return true;
        }

        boolean setBugsFile(String filename) {
            if (!this.bugsFile.isEmpty()) {
                this.err.println("Bugs file already set to " + this.bugsFile);
                return false;
            }
            this.bugsFile = filename;
            return true;
        }

        public Set<String> readBugsFile() throws IOException {
            HashSet<String> bugs = new HashSet<String>();
            if (this.bugsFile.isEmpty()) {
                return bugs;
            }
            File file = new File(this.bugsFile);
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("//")) continue;
                    bugs.add(line);
                }
            }
            return bugs;
        }

        public void message(String message, int importance) {
            if (this.verbosity >= importance) {
                this.out.println(message);
            }
        }

        public void registerExecutor(String executorName, Supplier<SqlSltTestExecutor> executor) {
            if (this.executorFactories.containsKey(executorName)) {
                throw new RuntimeException("Executor for " + Utilities.singleQuote(executorName) + " already registered");
            }
            this.executorFactories.put(executorName, executor);
        }

        private SuppliedOptions abort(@Nullable String message) {
            return this.abort(this.exit, message);
        }

        public @Nullable SqlSltTestExecutor getExecutorByName(String executor) {
            Supplier<SqlSltTestExecutor> supplier = this.executorFactories.get(executor);
            if (supplier == null) {
                this.err.println("Executor for " + Utilities.singleQuote(executor) + " not registered using 'registerExecutor");
                this.err.println("Registered executors:");
                for (String s : this.executorFactories.keySet()) {
                    this.err.println("\t" + s);
                }
                this.abort(null);
                return null;
            }
            return supplier.get();
        }

        public @Nullable SqlSltTestExecutor getExecutor() {
            if (this.executor == null || this.executor.isEmpty()) {
                this.abort("Please supply an executor name using the -e flag");
                return null;
            }
            return this.getExecutorByName(this.executor);
        }

        void error(String message) {
            this.err.println(message);
        }

        public void error(Throwable ex) {
            this.err.println("EXCEPTION: " + ex.getMessage());
        }

        public String toString() {
            return "Options{tests=" + this.directories + ", execute=" + !this.doNotExecute + ", executor=" + this.executor + ", stopAtFirstError=" + this.stopAtFirstError + '}';
        }
    }
}

