/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest.executors;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.hydromatic.sqllogictest.OptionsParser;
import net.hydromatic.sqllogictest.executors.JdbcExecutor;

public class HsqldbExecutor
extends JdbcExecutor {
    private static final AtomicLong HSQLDB_CONNECTION_ID = new AtomicLong(0L);

    public static void register(OptionsParser optionsParser) {
        optionsParser.registerExecutor("hsql", () -> {
            HsqldbExecutor result = new HsqldbExecutor(optionsParser.getOptions());
            try {
                Set<String> bugs = optionsParser.getOptions().readBugsFile();
                result.avoid(bugs);
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public HsqldbExecutor(OptionsParser.SuppliedOptions options) {
        super(options, "jdbc:hsqldb:mem:db" + HSQLDB_CONNECTION_ID.getAndIncrement(), "", "");
    }

    @Override
    List<String> getTableList() throws SQLException {
        List<String> result = super.getTableList();
        result = result.stream().filter(e -> !e.equals("PUBLIC")).collect(Collectors.toList());
        return result;
    }

    @Override
    public void establishConnection() throws SQLException {
        super.establishConnection();
        assert (this.connection != null);
        try (Statement statement = this.connection.createStatement();){
            statement.execute("SET DATABASE SQL SYNTAX PGS TRUE");
        }
    }
}

