/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.io.IOException;
import java.util.Set;
import net.hydromatic.sqllogictest.OptionsParser;
import net.hydromatic.sqllogictest.TestLoader;
import net.hydromatic.sqllogictest.executors.HsqldbExecutor;
import net.hydromatic.sqllogictest.executors.NoExecutor;
import net.hydromatic.sqllogictest.executors.PostgresExecutor;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public class Main {
    private Main() {
    }

    public static void main(String[] args) throws IOException {
        OptionsParser optionParser = new OptionsParser(true, System.out, System.err);
        Main.execute(optionParser, args);
    }

    public static int execute(OptionsParser optionParser, String ... args) throws IOException {
        optionParser.setBinaryName("slt");
        NoExecutor.register(optionParser);
        HsqldbExecutor.register(optionParser);
        PostgresExecutor.register(optionParser);
        OptionsParser.SuppliedOptions options = optionParser.parse(args);
        if (options.exitCode != 0) {
            return options.exitCode;
        }
        Set allTests = new Reflections("test", new Scanner[]{Scanners.Resources}).getResources(".*\\.test");
        TestLoader loader = new TestLoader(options);
        for (String testPath : allTests) {
            boolean runTest = options.getDirectories().stream().anyMatch(testPath::contains);
            if (!runTest || loader.visitFile(testPath)) continue;
            break;
        }
        options.out.println("Files that could not be not parsed: " + loader.fileParseErrors);
        loader.statistics.printStatistics(options.out);
        return 0;
    }
}

