/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest.executors;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.hydromatic.sqllogictest.ExecutionOptions;
import net.hydromatic.sqllogictest.executors.ExecutorFactory;
import net.hydromatic.sqllogictest.executors.JdbcExecutor;

public class PostgresExecutor
extends JdbcExecutor {
    public PostgresExecutor(ExecutionOptions options, String username, String password) {
        super(options, "jdbc:postgresql://localhost/slt", username, password);
    }

    List<String> getStringResults(String query) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        assert (this.connection != null);
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                String tableName = rs.getString(1);
                result.add(tableName);
            }
        }
        return result;
    }

    @Override
    List<String> getTableList() throws SQLException {
        return this.getStringResults("SELECT tableName FROM pg_catalog.pg_tables\n    WHERE schemaname != 'information_schema' AND\n    schemaname != 'pg_catalog'");
    }

    @Override
    List<String> getViewList() throws SQLException {
        return this.getStringResults("SELECT table_name\nFROM information_schema.views\nWHERE table_schema NOT IN ('information_schema', 'pg_catalog')\n");
    }

    public static class Factory
    extends ExecutorFactory {
        String username = "";
        String password = "";
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public void register(ExecutionOptions options) {
            options.registerOption("-u", "username", "Postgres user name", o -> {
                this.username = o;
                return true;
            });
            options.registerOption("-p", "password", "Postgres password", o -> {
                this.password = o;
                return true;
            });
            options.registerExecutor("psql", () -> {
                PostgresExecutor result = new PostgresExecutor(options, this.username, this.password);
                try {
                    Set<String> bugs = options.readBugsFile();
                    result.avoid(bugs);
                    return result;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

