/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.sqllogictest.SqlTestQuery;
import net.hydromatic.sqllogictest.util.StringPrintStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TestStatistics {
    static final DecimalFormat DF = new DecimalFormat("#,###");
    int failed;
    int passed;
    int ignored;
    final List<FailedTestDescription> failures = new ArrayList<FailedTestDescription>();
    final boolean stopAtFirstErrror;

    public void incPassed() {
        ++this.passed;
    }

    public void incIgnored() {
        ++this.ignored;
    }

    public void setPassed(int n) {
        this.passed = n;
    }

    public void setFailed(int n) {
        this.failed = n;
    }

    public void setIgnored(int n) {
        this.ignored = n;
    }

    public void add(TestStatistics stats) {
        this.failed += stats.failed;
        this.passed += stats.passed;
        this.ignored += stats.ignored;
        this.failures.addAll(stats.failures);
    }

    public int getFailed() {
        return this.failed;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getIgnored() {
        return this.ignored;
    }

    public TestStatistics(boolean stopAtFirstError) {
        this.stopAtFirstErrror = stopAtFirstError;
    }

    public boolean addFailure(FailedTestDescription failure) {
        this.failures.add(failure);
        ++this.failed;
        return this.stopAtFirstErrror;
    }

    public int testsRun() {
        return this.passed + this.ignored + this.failed;
    }

    public void printStatistics(PrintStream out) {
        out.println("Passed: " + DF.format(this.passed));
        out.println("Failed: " + DF.format(this.failed));
        out.println("Ignored: " + DF.format(this.ignored));
        if (!this.failures.isEmpty()) {
            out.print(this.failures.size());
            out.println(" failures:");
        }
        for (FailedTestDescription failure : this.failures) {
            out.println(failure.toString());
        }
    }

    public int totalTests() {
        return this.failed + this.passed + this.ignored;
    }

    public static class FailedTestDescription {
        public final SqlTestQuery query;
        public final String error;
        public final @Nullable Throwable exception;
        public final boolean verbose;

        public FailedTestDescription(SqlTestQuery query, String error, @Nullable Throwable exception, boolean verbose) {
            this.query = query;
            this.error = error;
            this.exception = exception;
            this.verbose = verbose;
        }

        public String toString() {
            String result = "ERROR: " + this.error + System.lineSeparator() + "\t" + this.query.file + ":" + this.query.line + System.lineSeparator() + "\t" + this.query;
            if (this.exception != null && this.verbose) {
                StringPrintStream str = new StringPrintStream();
                this.exception.printStackTrace(str.getPrintStream());
                result = result + System.lineSeparator() + str;
            }
            return result;
        }
    }
}

