/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlTestQueryOutputDescription {
    int valueCount = 0;
    public @Nullable String columnTypes = null;
    public @Nullable String hash = null;
    SortOrder order = SortOrder.NONE;
    @Nullable List<String> queryResults = null;

    public SortOrder getOrder() {
        return this.order;
    }

    public @Nullable List<String> getQueryResults() {
        return this.queryResults;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public void clearResults() {
        this.queryResults = new ArrayList<String>();
    }

    public void addResultLine(String line) {
        if (this.queryResults == null) {
            throw new RuntimeException("queryResults were not initialized");
        }
        this.queryResults.add(line);
        ++this.valueCount;
    }

    @Nullable String parseType(String line) {
        int space = line.indexOf(" ");
        if (space < 0) {
            throw new RuntimeException("No column types identified");
        }
        this.columnTypes = line.substring(0, space).trim();
        block3: for (int i = 0; i < this.columnTypes.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case 'I': 
                case 'R': 
                case 'T': {
                    continue block3;
                }
                default: {
                    throw new RuntimeException("Unexpected column type " + c);
                }
            }
        }
        return line.substring(space + 1);
    }

    @Nullable String parseOrder(String orderDescription) {
        if (orderDescription.startsWith("nosort")) {
            this.order = SortOrder.NONE;
            return orderDescription.substring("nosort".length());
        }
        if (orderDescription.startsWith("rowsort")) {
            this.order = SortOrder.ROW;
            return orderDescription.substring("rowsort".length());
        }
        if (orderDescription.startsWith("valuesort")) {
            this.order = SortOrder.VALUE;
            return orderDescription.substring("valuesort".length());
        }
        return null;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setValueCount(int values) {
        this.valueCount = values;
    }

    public int getExpectedOutputSize() {
        if (this.columnTypes == null || this.valueCount < 0) {
            return -1;
        }
        return this.valueCount / this.columnTypes.length();
    }

    public static enum SortOrder {
        NONE,
        ROW,
        VALUE;

    }
}

