/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterEntityReference;
import au.id.jericho.lib.html.NumericCharacterReference;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Util;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    protected static final int MAX_CODE_POINT = 0x10FFFF;
    private static final int TAB_LENGTH = 4;
    public static boolean ApostropheEncoded = true;

    CharacterReference(Source source, int n, int n2, int n3) {
        super(source, n, n2);
        this.codePoint = n3;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public static String encode(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(charSequence.length() * 2), charSequence, false).toString();
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(charSequence.length() * 2), charSequence, true).toString();
    }

    public static String decode(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        String string = ((Object)charSequence).toString();
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        return CharacterReference.appendDecode(new StringBuffer(string.length()), string, n).toString();
    }

    public static String decodeCollapseWhiteSpace(CharSequence charSequence) {
        return CharacterReference.decode(CharacterReference.appendCollapseWhiteSpace(new StringBuffer(charSequence.length()), charSequence));
    }

    public static String reencode(CharSequence charSequence) {
        return CharacterReference.encode(CharacterReference.decode(charSequence));
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int n) {
        String string = null;
        if (n != 39) {
            string = CharacterEntityReference.getCharacterReferenceString(n);
        }
        if (string == null) {
            string = NumericCharacterReference.getCharacterReferenceString(n);
        }
        return string;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int n) {
        return CharacterReference.appendDecimalCharacterReferenceString(new StringBuffer(), n).toString();
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int n) {
        return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuffer(), n).toString();
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int n) {
        return CharacterReference.appendUnicodeText(new StringBuffer(), n).toString();
    }

    protected static final StringBuffer appendUnicodeText(StringBuffer stringBuffer, int n) {
        stringBuffer.append("U+");
        String string = Integer.toString(n, 16).toUpperCase();
        for (int i = 4 - string.length(); i > 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static CharacterReference parse(CharSequence charSequence) {
        return CharacterReference.construct(new Source(((Object)charSequence).toString()), 0);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence charSequence) {
        CharacterReference characterReference = CharacterReference.parse(charSequence);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char c) {
        return c > '\u007f' || CharacterEntityReference.getName(c) != null && (c != '\'' || ApostropheEncoded);
    }

    protected static StringBuffer appendEncode(StringBuffer stringBuffer, CharSequence charSequence, boolean bl) {
        if (charSequence == null) {
            return stringBuffer;
        }
        int n = 0;
        int n2 = charSequence.length();
        if (charSequence instanceof Segment) {
            int c;
            Segment segment = (Segment)charSequence;
            n = c = segment.getBegin();
            n2 += c;
            charSequence = segment.source.toString();
        }
        for (int i = n; i < n2; ++i) {
            int n3;
            char c = charSequence.charAt(i);
            String string = CharacterEntityReference.getName(c);
            if (string != null) {
                if (c == '\'') {
                    if (ApostropheEncoded) {
                        stringBuffer.append("&#39;");
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                CharacterEntityReference.appendCharacterReferenceString(stringBuffer, string);
                continue;
            }
            if (c > '\u007f') {
                CharacterReference.appendDecimalCharacterReferenceString(stringBuffer, c);
                continue;
            }
            if (!bl || !CharacterReference.isWhiteSpace(c)) {
                stringBuffer.append(c);
                continue;
            }
            int n4 = i + 1;
            if (c != ' ') {
                if (c != '\t') {
                    if (c == '\r' && n4 < n2 && charSequence.charAt(n4) == '\n') {
                        ++i;
                    }
                    stringBuffer.append("<br />");
                    continue;
                }
                n3 = 4;
            } else {
                n3 = 1;
            }
            while (n4 < n2) {
                c = charSequence.charAt(n4);
                if (c == ' ') {
                    ++n3;
                } else {
                    if (c != '\t') break;
                    n3 += 4;
                }
                ++n4;
            }
            if (n3 == 1) {
                stringBuffer.append(' ');
                continue;
            }
            if (n3 % 2 == 1) {
                stringBuffer.append(' ');
            }
            while (n3 >= 2) {
                stringBuffer.append("&nbsp; ");
                n3 -= 2;
            }
            i = n4 - 1;
        }
        return stringBuffer;
    }

    static CharacterReference findPreviousOrNext(Source source, int n, boolean bl) {
        String string = source.getParseTextLowerCase();
        int n2 = n = bl ? string.lastIndexOf(38, n) : string.indexOf(38, n);
        while (n != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, n);
            if (characterReference != null) {
                return characterReference;
            }
            n = bl ? string.lastIndexOf(38, n - 1) : string.indexOf(38, n + 1);
        }
        return null;
    }

    protected static final StringBuffer appendHexadecimalCharacterReferenceString(StringBuffer stringBuffer, int n) {
        return stringBuffer.append("&#x").append(Integer.toString(n, 16)).append(';');
    }

    protected static final StringBuffer appendDecimalCharacterReferenceString(StringBuffer stringBuffer, int n) {
        return stringBuffer.append("&#").append(n).append(';');
    }

    static CharacterReference construct(Source source, int n) {
        try {
            if (source.getParseTextLowerCase().charAt(n) != '&') {
                return null;
            }
            return source.getParseTextLowerCase().charAt(n + 1) == '#' ? NumericCharacterReference.construct(source, n) : CharacterEntityReference.construct(source, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private static StringBuffer appendDecode(StringBuffer stringBuffer, String string) {
        if (string == null) {
            return stringBuffer;
        }
        int n = string.indexOf(38);
        if (n == -1) {
            return stringBuffer.append(string);
        }
        return CharacterReference.appendDecode(stringBuffer, string, n);
    }

    private static StringBuffer appendDecode(StringBuffer stringBuffer, String string, int n) {
        CharacterReference characterReference;
        int n2 = 0;
        Source source = new Source(string);
        while ((characterReference = CharacterReference.findPreviousOrNext(source, n, false)) != null) {
            if (n2 != characterReference.getBegin()) {
                Util.appendTo(stringBuffer, (CharSequence)string, n2, characterReference.getBegin());
            }
            stringBuffer.append((char)characterReference.codePoint);
            n = n2 = characterReference.getEnd();
        }
        if (n2 != string.length()) {
            Util.appendTo(stringBuffer, (CharSequence)string, n2, string.length());
        }
        return stringBuffer;
    }
}

