/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Writer;

public final class Attribute
extends Segment {
    private String key;
    private Segment nameSegment;
    private Segment valueSegment;
    private Segment valueSegmentIncludingQuotes;
    protected static final String CHECKED = "checked";
    protected static final String CLASS = "class";
    protected static final String DISABLED = "disabled";
    protected static final String ID = "id";
    protected static final String MULTIPLE = "multiple";
    protected static final String NAME = "name";
    protected static final String SELECTED = "selected";
    protected static final String STYLE = "style";
    protected static final String TYPE = "type";
    protected static final String VALUE = "value";

    Attribute(Source source, String string, Segment segment) {
        this(source, string, segment, null, null);
    }

    Attribute(Source source, String string, Segment segment, Segment segment2, Segment segment3) {
        super(source, segment.getBegin(), segment3 == null ? segment.getEnd() : segment3.getEnd());
        this.key = string;
        this.nameSegment = segment;
        this.valueSegment = segment2;
        this.valueSegmentIncludingQuotes = segment3;
    }

    public String getKey() {
        return this.key;
    }

    public Segment getNameSegment() {
        return this.nameSegment;
    }

    public Segment getValueSegment() {
        return this.valueSegment;
    }

    public Segment getValueSegmentIncludingQuotes() {
        return this.valueSegmentIncludingQuotes;
    }

    public char getQuoteChar() {
        if (this.valueSegment == this.valueSegmentIncludingQuotes) {
            return ' ';
        }
        return this.source.charAt(this.valueSegmentIncludingQuotes.getBegin());
    }

    public String getName() {
        return this.nameSegment.toString();
    }

    public String getValue() {
        return CharacterReference.decode(this.valueSegment);
    }

    public boolean hasValue() {
        return this.valueSegment != null;
    }

    protected StringBuffer appendRegeneratedHTML(StringBuffer stringBuffer) {
        return Attribute.appendHTML(stringBuffer, (CharSequence)this.getName(), (CharSequence)this.getValue());
    }

    protected static StringBuffer appendHTML(StringBuffer stringBuffer, CharSequence charSequence, CharSequence charSequence2) {
        stringBuffer.append(' ');
        Util.appendTo(stringBuffer, charSequence);
        if (charSequence2 != null) {
            stringBuffer.append("=\"");
            CharacterReference.appendEncode(stringBuffer, charSequence2, false);
            stringBuffer.append('\"');
        }
        return stringBuffer;
    }

    protected static Writer appendHTML(Writer writer, CharSequence charSequence, CharSequence charSequence2) throws IOException {
        writer.write(32);
        Util.appendTo(writer, charSequence);
        if (charSequence2 != null) {
            writer.write("=\"");
            writer.write(CharacterReference.encode(charSequence2));
            writer.write(34);
        }
        return writer;
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.key).append(super.getDebugInfo()).append(",name=").append(this.nameSegment.getDebugInfo());
        if (this.hasValue()) {
            stringBuffer.append(",value=").append(this.valueSegment.getDebugInfo()).append('\"').append((Object)this.valueSegment).append("\"\n");
        } else {
            stringBuffer.append(",NO VALUE\n");
        }
        return stringBuffer.toString();
    }
}

