import au.id.jericho.lib.html.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class DisplaySpecialTags {
	public static void main(String[] args) throws Exception {
		String sourceUrlString="data/test.html";
		if (args.length==0)
		  System.err.println("Using default argument of \""+sourceUrlString+'"');
		else
			sourceUrlString=args[0];
		if (sourceUrlString.indexOf(':')==-1) sourceUrlString="file:"+sourceUrlString;
		URL sourceUrl=new URL(sourceUrlString);
 		String htmlText=Util.getString(new InputStreamReader(sourceUrl.openStream()));
		Source source=new Source(htmlText);
		source.setLogWriter(new OutputStreamWriter(System.err)); // send log messages to stderr
		System.out.println("\n*******************************************************************************\n");

		System.out.println("Document Type Declarations:");
		displaySegments(source.findAllStartTags(Tag.DOCTYPE_DECLARATION));

		System.out.println("XML Declarations:");
		displaySegments(source.findAllStartTags(Tag.XML_DECLARATION));

		System.out.println("Processing instructions: (eg XML declarations, PHP short form tags, etc)");
		displaySegments(source.findAllStartTags(Tag.PROCESSING_INSTRUCTION));

		System.out.println("Common server tags: (eg ASP, JSP, PSP, ASP-style PHP or Mason substitution tag)");
		displaySegments(source.findAllStartTags(Tag.SERVER_COMMON));

		// Note: The end of a PHP tag can not be reliably found without the use of a PHP parser,
		// meaning any PHP tag found by this library is not guaranteed to have the correct end position.
		System.out.println("PHP tags:");
		displaySegments(source.findAllStartTags(Tag.SERVER_PHP));

		System.out.println("Mason Component Calls:");
		displaySegments(source.findAllStartTags(Tag.SERVER_MASON_COMPONENT_CALL));

		// Note that the following two searches find elements rather than start tags:

		System.out.println("Mason Components Called With Content:");
		displaySegments(source.findAllElements(Tag.SERVER_MASON_COMPONENT_CALLED_WITH_CONTENT));

		System.out.println("Mason Named Blocks:");
		displaySegments(source.findAllElements(Tag.SERVER_MASON_NAMED_BLOCK));

		// A convenience method is supplied to search for comments rather than using a Tag object:
		System.out.println("HTML Comments:");
		displaySegments(source.findAllComments());

  }

	private static void displaySegments(List segments) {
		for (Iterator i=segments.iterator(); i.hasNext();) {
			Segment segment=(Segment)i.next();
			System.out.println("-------------------------------------------------------------------------------");
			System.out.println(segment.getDebugInfo());
			System.out.println(segment);
		}
		System.out.println("\n*******************************************************************************\n");
	}
}
