import au.id.jericho.lib.html.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class ConvertStyleSheets {
	public static void main(String[] args) throws Exception {
		String sourceUrlString="data/form.html";
		if (args.length==0)
		  System.err.println("Using default argument of \""+sourceUrlString+'"');
		else
			sourceUrlString=args[0];
		if (sourceUrlString.indexOf(':')==-1) sourceUrlString="file:"+sourceUrlString;
		URL sourceUrl=new URL(sourceUrlString);
 		String htmlText=Util.getString(new InputStreamReader(sourceUrl.openStream()));
		OutputDocument outputDocument=new OutputDocument(htmlText);
		Source source=new Source(htmlText);
		source.setLogWriter(new OutputStreamWriter(System.err)); // send log messages to stderr
		StringBuffer sb=new StringBuffer();
		List linkStartTags=source.findAllStartTags("link");
		for (Iterator i=linkStartTags.iterator(); i.hasNext();) {
			StartTag startTag=(StartTag)i.next();
			Attributes attributes=startTag.getAttributes();
			Attribute relAttribute=attributes.get("rel");
			if (relAttribute==null || !"stylesheet".equalsIgnoreCase(relAttribute.getValue())) continue;
			Attribute hrefAttribute=attributes.get("href");
			if (hrefAttribute==null) continue;
			String href=hrefAttribute.getValue();
			if (href==null) continue;
			String styleSheetContent;
			try {
				styleSheetContent=Util.getString(new InputStreamReader(new URL(sourceUrl,href).openStream()));
			} catch (Exception ex) {
			  System.err.println(ex.toString());
				continue; // don't convert if URL is invalid
			}
			sb.setLength(0);
			sb.append("<style");
			Attribute typeAttribute=attributes.get("type");
			if (typeAttribute!=null) sb.append(' ').append(typeAttribute);
			sb.append(">\n").append(styleSheetContent).append("\n</style>");
			outputDocument.add(new StringOutputSegment(startTag,sb.toString()));
		}
		System.err.println("Here is the document "+sourceUrlString+" with all external stylesheets converted to inline stylesheets:\n");
		outputDocument.output(new OutputStreamWriter(System.out));
  }
}
