/*
 * Decompiled with CFR 0.152.
 */
package net.hlinfo.utils.spring.configure;

import net.hlinfo.mybatis.dao.MybatisDao;
import net.hlinfo.mybatis.dao.impl.MybatisDaoImpl;
import net.hlinfo.mybatis.opt.HlinfoDriverClassConfig;
import net.hlinfo.mybatis.service.MybatisService;
import net.hlinfo.mybatis.service.impl.MybatisServiceImpl;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HlinfoDriverClassConfig.class})
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
public class HlinfoMybatisDaoAutoConfiguration {
    private HlinfoDriverClassConfig driverClassConfig;

    public HlinfoMybatisDaoAutoConfiguration(HlinfoDriverClassConfig driverClassConfig) {
        this.driverClassConfig = driverClassConfig;
    }

    @Bean
    public MybatisDao mybatisDao(SqlSessionTemplate sqlSessionTemplate) {
        MybatisDaoImpl mybatisDao = new MybatisDaoImpl(sqlSessionTemplate);
        return mybatisDao;
    }

    @Bean
    public MybatisService mybatisService(MybatisDao mybatisDao) {
        MybatisServiceImpl mybatisService = new MybatisServiceImpl(mybatisDao, this.driverClassConfig);
        return mybatisService;
    }
}

