/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.neta.handler.codec.string;

import java.nio.charset.Charset;
import java.util.Objects;
import net.hasor.neta.bytebuf.ByteBuf;
import net.hasor.neta.bytebuf.ByteBufAllocator;
import net.hasor.neta.channel.PipeContext;
import net.hasor.neta.handler.PipeHandler;
import net.hasor.neta.handler.PipeRcvQueue;
import net.hasor.neta.handler.PipeSndQueue;
import net.hasor.neta.handler.PipeStatus;

public class StringEncoderHandler
implements PipeHandler<String, ByteBuf> {
    private final Charset charset;

    public StringEncoderHandler() {
        this(Charset.defaultCharset());
    }

    public StringEncoderHandler(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "charset");
    }

    public PipeStatus onMessage(PipeContext context, PipeRcvQueue<String> src, PipeSndQueue<ByteBuf> dst) {
        boolean hasAny = false;
        while (src.hasMore()) {
            String string = (String)src.takeMessage();
            if (string == null) continue;
            dst.offerMessage((Object)ByteBufAllocator.DEFAULT.wrap(string.getBytes(this.charset)));
            hasAny = true;
        }
        return hasAny ? PipeStatus.Next : PipeStatus.Exit;
    }
}

