/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.neta.handler.codec.string;

import java.nio.charset.Charset;
import java.util.Objects;
import net.hasor.neta.bytebuf.ByteBuf;
import net.hasor.neta.channel.PipeContext;
import net.hasor.neta.handler.PipeHandler;
import net.hasor.neta.handler.PipeRcvQueue;
import net.hasor.neta.handler.PipeSndQueue;
import net.hasor.neta.handler.PipeStatus;

public class StringDecoderHandler
implements PipeHandler<ByteBuf, String> {
    private final Charset charset;

    public StringDecoderHandler() {
        this(Charset.defaultCharset());
    }

    public StringDecoderHandler(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "charset");
    }

    public PipeStatus onMessage(PipeContext context, PipeRcvQueue<ByteBuf> src, PipeSndQueue<String> dst) {
        boolean hasAny = false;
        while (src.hasMore()) {
            ByteBuf byteBuf = (ByteBuf)src.takeMessage();
            if (byteBuf == null) continue;
            dst.offerMessage((Object)byteBuf.readString(byteBuf.readableBytes(), this.charset));
            hasAny = true;
        }
        return hasAny ? PipeStatus.Next : PipeStatus.Exit;
    }
}

