/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.neta.handler.codec;

import java.util.Objects;
import net.hasor.neta.bytebuf.ByteBuf;
import net.hasor.neta.bytebuf.ByteBufAllocator;
import net.hasor.neta.channel.PipeContext;
import net.hasor.neta.handler.PipeHandler;
import net.hasor.neta.handler.PipeRcvQueue;
import net.hasor.neta.handler.PipeSndQueue;
import net.hasor.neta.handler.PipeStatus;

public class LimitFrameHandler
implements PipeHandler<ByteBuf, ByteBuf> {
    private final int maxLength;
    private final ByteBufAllocator bufAllocator;

    public LimitFrameHandler(int maxLength) {
        this(maxLength, ByteBufAllocator.DEFAULT);
    }

    public LimitFrameHandler(int maxLength, ByteBufAllocator bufAllocator) {
        this.maxLength = maxLength;
        this.bufAllocator = Objects.requireNonNull(bufAllocator);
    }

    public PipeStatus onMessage(PipeContext context, PipeRcvQueue<ByteBuf> src, PipeSndQueue<ByteBuf> dst) {
        ByteBuf srcBuf;
        ByteBuf dstBuf = null;
        while (src.hasMore() && dst.hasSlot() && (srcBuf = (ByteBuf)src.peekMessage()) != null) {
            while (srcBuf.hasReadable() && dst.hasSlot()) {
                if (dstBuf == null) {
                    dstBuf = this.bufAllocator.pooledBuffer();
                }
                int read = this.fillLimitFrame(srcBuf, dstBuf);
                if (dstBuf.writerIndex() != this.maxLength) continue;
                dstBuf.markWriter();
                dst.offerMessage((Object)dstBuf);
                dstBuf = null;
            }
            if (srcBuf.hasReadable()) continue;
            src.skipMessage(1);
        }
        if (dstBuf != null) {
            dstBuf.markWriter();
            dst.offerMessage(dstBuf);
        }
        return PipeStatus.Next;
    }

    private int fillLimitFrame(ByteBuf src, ByteBuf dst) {
        int wlen = Math.min(src.readableBytes(), this.maxLength - dst.writerIndex());
        int len = src.read(dst, wlen);
        src.markReader();
        return len;
    }
}

