/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.neta.handler.codec.string;

import java.nio.charset.Charset;
import java.util.Objects;
import net.hasor.neta.bytebuf.ByteBuf;
import net.hasor.neta.channel.PipeContext;
import net.hasor.neta.handler.PipeDuplex;
import net.hasor.neta.handler.PipeRcvQueue;
import net.hasor.neta.handler.PipeSndQueue;
import net.hasor.neta.handler.PipeStatus;
import net.hasor.neta.handler.codec.string.StringDecoderHandler;
import net.hasor.neta.handler.codec.string.StringEncoderHandler;

public class StringPipeLayer
implements PipeDuplex<ByteBuf, String, String, ByteBuf> {
    private final StringDecoderHandler stringDecoder;
    private final StringEncoderHandler stringEncoder;

    public StringPipeLayer() {
        this(Charset.defaultCharset());
    }

    public StringPipeLayer(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        this.stringDecoder = new StringDecoderHandler(charset);
        this.stringEncoder = new StringEncoderHandler(charset);
    }

    public PipeStatus onMessage(PipeContext context, boolean isRcv, PipeRcvQueue<ByteBuf> rcvUp, PipeSndQueue<String> rcvDown, PipeRcvQueue<String> sndUp, PipeSndQueue<ByteBuf> sndDown) {
        if (isRcv) {
            return this.stringDecoder.onMessage(context, rcvUp, rcvDown);
        }
        return this.stringEncoder.onMessage(context, sndUp, sndDown);
    }
}

