/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.neta.handler.codec;

import java.util.ArrayList;
import java.util.List;
import net.hasor.neta.bytebuf.ByteBuf;
import net.hasor.neta.bytebuf.ByteBufAllocator;
import net.hasor.neta.channel.PipeContext;
import net.hasor.neta.handler.PipeHandler;
import net.hasor.neta.handler.PipeRcvQueue;
import net.hasor.neta.handler.PipeSndQueue;
import net.hasor.neta.handler.PipeStatus;
import net.hasor.neta.handler.codec.TooLongFrameException;

public class LineBasedFrameHandler
implements PipeHandler<ByteBuf, ByteBuf> {
    private final int maxLength;
    private final boolean stripDelimiter;

    public LineBasedFrameHandler() {
        this(Integer.MAX_VALUE, true);
    }

    public LineBasedFrameHandler(int maxLength) {
        this(maxLength, true);
    }

    public LineBasedFrameHandler(int maxLength, boolean stripDelimiter) {
        this.maxLength = maxLength;
        this.stripDelimiter = stripDelimiter;
    }

    public PipeStatus onMessage(PipeContext context, PipeRcvQueue<ByteBuf> src, PipeSndQueue<ByteBuf> dst) {
        ByteBuf line;
        if (!src.hasMore()) {
            return PipeStatus.Next;
        }
        List peekArray = src.peekMessage(src.queueSize());
        while (src.hasMore() && (line = this.expectLine(context, src, peekArray)) != null) {
            dst.offerMessage((Object)line);
        }
        return PipeStatus.Next;
    }

    private ByteBuf expectLine(PipeContext context, PipeRcvQueue<ByteBuf> src, List<ByteBuf> peekArray) {
        ArrayList<ByteBuf> temp = new ArrayList<ByteBuf>();
        boolean hasLine = false;
        int consumedBytes = 0;
        for (ByteBuf buf : peekArray) {
            consumedBytes += buf.readableBytes();
            temp.add(buf);
            if (!buf.hasLine()) continue;
            hasLine = true;
            break;
        }
        if (!hasLine) {
            if (this.maxLength > 0 && consumedBytes > this.maxLength) {
                throw new TooLongFrameException("frame length " + consumedBytes + " exceeds " + this.maxLength);
            }
            return null;
        }
        ByteBufAllocator allocator = context.getSoContext().getResourceManager().getByteBufAllocator();
        ByteBuf tmpBuf = allocator.buffer(consumedBytes);
        int lastIndex = temp.size() - 1;
        for (int i = 0; i < temp.size(); ++i) {
            ByteBuf buf = (ByteBuf)temp.get(i);
            if (i != lastIndex) {
                buf.read(tmpBuf);
                buf.markReader();
                src.skipMessage(1);
                continue;
            }
            int readLen = buf.expectLine();
            int skipLen = 0;
            if (this.stripDelimiter) {
                readLen = buf.getUInt8(readLen) == 13 ? (readLen += 2) : ++readLen;
            } else {
                skipLen = buf.getUInt8(readLen) == 13 ? 2 : 1;
            }
            buf.read(tmpBuf, readLen);
            buf.skipReadableBytes(skipLen);
            buf.markReader();
            if (buf.hasReadable()) continue;
            src.skipMessage(1);
        }
        tmpBuf.markWriter();
        return tmpBuf;
    }
}

