/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.neta.handler.codec;
/**
 * An {@link CodecException} which is thrown when the length of the frame
 * decoded is greater than the allowed maximum.
 * @author 赵永春 (zyc@hasor.net)
 * @version : 2024-01-20
 */
public class TooLongFrameException extends CodecException {

    private static final long serialVersionUID = -1995801950698951640L;

    /** Creates a new instance. */
    public TooLongFrameException() {
    }

    /** Creates a new instance. */
    public TooLongFrameException(String message, Throwable cause) {
        super(message, cause);
    }

    /** Creates a new instance. */
    public TooLongFrameException(String message) {
        super(message);
    }

    /** Creates a new instance. */
    public TooLongFrameException(Throwable cause) {
        super(cause);
    }
}
