/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.listener.ListenerPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeListener
implements ServletContextListener,
HttpSessionListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String AppContextName = AppContext.class.getName();
    private AppContext appContext = null;
    private ListenerPipeline listenerPipeline = null;

    protected Hasor newHasor(ServletContext sc, String configName, Properties properties) throws Throwable {
        Hasor webHasor = Hasor.create((Object)sc);
        if (StringUtils.isNotBlank((String)configName)) {
            webHasor.mainSettingWith(configName);
        }
        properties.keySet().forEach(key -> {
            String keyStr = key.toString();
            webHasor.addVariable(keyStr, properties.getProperty(keyStr));
        });
        String webContextDir = sc.getRealPath("/");
        webHasor.addVariable("HASOR_WEBROOT", webContextDir);
        return webHasor;
    }

    protected Module newRootModule(ServletContext sc, String rootModule) throws Exception {
        if (StringUtils.isBlank((String)rootModule)) {
            this.logger.info("web initModule is undefinition.");
            return null;
        }
        Class<?> startModuleClass = Thread.currentThread().getContextClassLoader().loadClass(rootModule);
        this.logger.info("web initModule is " + rootModule);
        return (Module)startModuleClass.newInstance();
    }

    protected Properties loadEnvProperties(ServletContext sc, String envPropertieName) throws IOException {
        if (StringUtils.isBlank((String)envPropertieName)) {
            this.logger.info("properties file is undefinition.");
            return null;
        }
        InputStream resourceAsStream = ResourcesUtils.getResourceAsStream((String)envPropertieName);
        if (resourceAsStream == null) {
            this.logger.error("properties file is " + envPropertieName + " , but there is not exist.");
            return null;
        }
        this.logger.info("properties file is " + envPropertieName);
        Properties prop = new Properties();
        prop.load(new InputStreamReader(resourceAsStream, "UTF-8"));
        return prop;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ServletContext sc = servletContextEvent.getServletContext();
            String rootModule = sc.getInitParameter("hasor-root-module");
            String configName = sc.getInitParameter("hasor-hconfig-name");
            String envProperties = sc.getInitParameter("hasor-env-properties");
            Properties properties = this.loadEnvProperties(sc, envProperties);
            Module startModule = this.newRootModule(sc, rootModule);
            this.appContext = this.newHasor(sc, configName, properties).build(new Module[]{startModule});
        }
        catch (Throwable e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        this.listenerPipeline = (ListenerPipeline)this.appContext.getInstance(ListenerPipeline.class);
        this.listenerPipeline.init(this.appContext);
        this.logger.info("sessionListenerPipeline created.");
        this.logger.info("ServletContext Attribut is " + AppContextName);
        servletContextEvent.getServletContext().setAttribute(AppContextName, (Object)this.appContext);
        this.listenerPipeline.contextInitialized(servletContextEvent);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.listenerPipeline != null) {
            this.listenerPipeline.contextDestroyed(servletContextEvent);
        }
        if (this.appContext != null) {
            this.appContext.shutdown();
        }
        this.logger.info("shutdown.");
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (this.listenerPipeline != null) {
            this.listenerPipeline.sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.listenerPipeline != null) {
            this.listenerPipeline.sessionDestroyed(se);
        }
    }

    public static AppContext getAppContext(ServletContext servletContext) {
        return (AppContext)servletContext.getAttribute(AppContextName);
    }
}

