/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.listener;

import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpSessionEvent;
import net.hasor.core.AppContext;
import net.hasor.web.definition.ContextListenerDefinition;
import net.hasor.web.definition.HttpSessionListenerDefinition;
import net.hasor.web.listener.ListenerPipeline;

public class ManagedListenerPipeline
implements ListenerPipeline {
    private HttpSessionListenerDefinition[] sessionListeners = null;
    private ContextListenerDefinition[] contextListeners = null;
    private volatile boolean initialized = false;

    @Override
    public void init(AppContext appContext) {
        if (this.initialized) {
            return;
        }
        List sessionListeners = appContext.findBindingBean(HttpSessionListenerDefinition.class);
        for (HttpSessionListenerDefinition def : this.sessionListeners = sessionListeners.toArray(new HttpSessionListenerDefinition[0])) {
            def.init(appContext);
        }
        List contextListeners = appContext.findBindingBean(ContextListenerDefinition.class);
        for (ContextListenerDefinition def : this.contextListeners = contextListeners.toArray(new ContextListenerDefinition[0])) {
            def.init(appContext);
        }
        this.initialized = true;
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (!this.initialized) {
            return;
        }
        for (HttpSessionListenerDefinition httpSessionListenerDefinition : this.sessionListeners) {
            httpSessionListenerDefinition.sessionCreated(event);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (!this.initialized) {
            return;
        }
        for (HttpSessionListenerDefinition httpSessionListenerDefinition : this.sessionListeners) {
            httpSessionListenerDefinition.sessionDestroyed(event);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        if (!this.initialized) {
            return;
        }
        for (ContextListenerDefinition contextListenerDefinition : this.contextListeners) {
            contextListenerDefinition.contextInitialized(event);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (!this.initialized) {
            return;
        }
        for (ContextListenerDefinition contextListenerDefinition : this.contextListeners) {
            contextListenerDefinition.contextDestroyed(event);
        }
    }
}

