/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContextAware;
import net.hasor.core.BindInfo;
import net.hasor.core.Environment;
import net.hasor.core.HasorUtils;
import net.hasor.core.binder.ApiBinderWrap;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.utils.CheckUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.InvokerFilter;
import net.hasor.web.MappingDiscoverer;
import net.hasor.web.RenderEngine;
import net.hasor.web.ServletVersion;
import net.hasor.web.WebApiBinder;
import net.hasor.web.definition.AbstractDefinition;
import net.hasor.web.definition.ContextListenerDefinition;
import net.hasor.web.definition.FilterDefinition;
import net.hasor.web.definition.HttpSessionListenerDefinition;
import net.hasor.web.definition.InvokeFilterDefinition;
import net.hasor.web.definition.MappingDiscovererDefinition;
import net.hasor.web.definition.RenderDefinition;
import net.hasor.web.definition.UriPatternMatcher;
import net.hasor.web.definition.UriPatternType;
import net.hasor.web.invoker.InMappingDef;
import net.hasor.web.invoker.InMappingServlet;
import net.hasor.web.mime.MimeTypeSupplier;

public class InvokerWebApiBinder
extends ApiBinderWrap
implements WebApiBinder {
    private final InstanceProvider<String> requestEncoding = new InstanceProvider((Object)"");
    private final InstanceProvider<String> responseEncoding = new InstanceProvider((Object)"");
    private ServletVersion curVersion;
    private MimeTypeSupplier mimeType;

    protected InvokerWebApiBinder(ServletVersion curVersion, MimeTypeSupplier mimeType, ApiBinder apiBinder) {
        super(apiBinder);
        apiBinder.bindType(String.class).nameWith("HTTP_REQUEST_ENCODING").toProvider(this.requestEncoding);
        apiBinder.bindType(String.class).nameWith("HTTP_RESPONSE_ENCODING").toProvider(this.responseEncoding);
        this.curVersion = Objects.requireNonNull(curVersion);
        this.mimeType = Objects.requireNonNull(mimeType);
    }

    @Override
    public ServletContext getServletContext() {
        return (ServletContext)this.getEnvironment().getContext();
    }

    @Override
    public WebApiBinder setRequestCharacter(String encoding) {
        this.requestEncoding.set((Object)encoding);
        return this;
    }

    @Override
    public WebApiBinder setResponseCharacter(String encoding) {
        this.responseEncoding.set((Object)encoding);
        return this;
    }

    @Override
    public String getMimeType(String suffix) {
        return this.mimeType.getMimeType(suffix);
    }

    @Override
    public void addMimeType(String type, String mimeType) {
        this.mimeType.addMimeType(type, mimeType);
    }

    @Override
    public void loadMimeType(Reader reader) throws IOException {
        this.mimeType.loadReader(reader);
    }

    @Override
    public ServletVersion getServletVersion() {
        return this.curVersion;
    }

    @Override
    public void addDiscoverer(BindInfo<? extends MappingDiscoverer> discoverer) {
        Objects.requireNonNull(discoverer);
        MappingDiscovererDefinition definition = (MappingDiscovererDefinition)HasorUtils.autoAware((Environment)this.getEnvironment(), (AppContextAware)new MappingDiscovererDefinition(discoverer));
        this.bindType(MappingDiscovererDefinition.class).toInstance((Object)definition);
    }

    @Override
    public void addServletListener(BindInfo<? extends ServletContextListener> targetRegister) {
        this.bindType(ContextListenerDefinition.class).uniqueName().toInstance((Object)new ContextListenerDefinition(targetRegister));
    }

    @Override
    public void addSessionListener(BindInfo<? extends HttpSessionListener> targetRegister) {
        this.bindType(HttpSessionListenerDefinition.class).uniqueName().toInstance((Object)new HttpSessionListenerDefinition(targetRegister));
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<InvokerFilter> filter(String[] morePatterns) {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<InvokerFilter>(InvokerFilter.class, UriPatternType.SERVLET, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.filterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<InvokerFilter> filterRegex(String[] regexes) {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(regexes), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<InvokerFilter>(InvokerFilter.class, UriPatternType.REGEX, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.filterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<Filter> jeeFilter(String[] morePatterns) throws NullPointerException {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<Filter>(Filter.class, UriPatternType.SERVLET, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.jeeFilterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<Filter> jeeFilterRegex(String[] regexes) throws NullPointerException {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(regexes), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<Filter>(Filter.class, UriPatternType.REGEX, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.jeeFilterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    protected void filterThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
        InvokeFilterDefinition define = new InvokeFilterDefinition(index, pattern, matcher, filterRegister, initParams);
        this.bindType(AbstractDefinition.class).uniqueName().toInstance((Object)define);
        this.bindToCreater(filterRegister, define);
    }

    protected void jeeFilterThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
        FilterDefinition define = new FilterDefinition(index, pattern, matcher, filterRegister, initParams);
        this.bindType(AbstractDefinition.class).uniqueName().toInstance((Object)define);
        this.bindToCreater(filterRegister, define);
    }

    protected void jeeServlet(int index, String pattern, BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
        InMappingServlet define = new InMappingServlet(index, servletRegister, pattern, initParams, this.getServletContext());
        this.bindType(InMappingDef.class).uniqueName().toInstance((Object)define);
        this.bindToCreater(servletRegister, define);
    }

    @Override
    public WebApiBinder.ServletBindingBuilder jeeServlet(String[] morePatterns) {
        return new ServletsModuleBuilder(CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"Servlet patterns is empty."));
    }

    @Override
    public <T> WebApiBinder.MappingToBindingBuilder<T> mappingTo(final String[] morePatterns) {
        CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"mappingTo patterns is empty.");
        return new WebApiBinder.MappingToBindingBuilder<T>(){

            @Override
            public void with(int index, Class<? extends T> targetKey) {
                this.with(index, InvokerWebApiBinder.this.bindType(targetKey).uniqueName().toInfo());
            }

            @Override
            public void with(int index, T target) {
                Class<?> targetType = target.getClass();
                this.with(index, InvokerWebApiBinder.this.bindType(targetType).uniqueName().toInstance(target).toInfo());
            }

            @Override
            public void with(int index, Class<T> referKey, Supplier<? extends T> targetProvider) {
                this.with(index, InvokerWebApiBinder.this.bindType(referKey).uniqueName().toProvider(targetProvider).toInfo());
            }

            @Override
            public void with(int index, BindInfo<? extends T> targetInfo) {
                Arrays.stream(morePatterns).filter(StringUtils::isNotBlank).forEach(pattern -> {
                    InMappingDef define = new InMappingDef(index, targetInfo, (String)pattern, Matchers.anyMethod(), true);
                    InvokerWebApiBinder.this.bindType(InMappingDef.class).uniqueName().toInstance((Object)define);
                });
                logger.info("mapingTo[Object] -> bindID \u2018{}\u2019 mappingTo: \u2018{}\u2019.", (Object)targetInfo.getBindID(), (Object)morePatterns);
            }
        };
    }

    @Override
    public WebApiBinder.RenderEngineBindingBuilder addRender(String renderName, String specialMimeType) {
        return new RenderEngineBindingBuilderImpl(Objects.requireNonNull(renderName, "Render renderName is empty."), specialMimeType){

            @Override
            protected void bindRender(String renderName, String specialMimeType, BindInfo<? extends RenderEngine> bindInfo) {
                InvokerWebApiBinder.this.bindType(RenderDefinition.class).nameWith(renderName).toInstance((Object)new RenderDefinition(renderName, specialMimeType, bindInfo));
            }
        };
    }

    private abstract class RenderEngineBindingBuilderImpl
    implements WebApiBinder.RenderEngineBindingBuilder {
        private String renderName;
        private String specialMimeType;

        public RenderEngineBindingBuilderImpl(String renderName, String specialMimeType) {
            this.renderName = renderName;
            this.specialMimeType = specialMimeType;
        }

        @Override
        public <T extends RenderEngine> void to(Class<T> renderEngineType) {
            this.bindRender(this.renderName, this.specialMimeType, (BindInfo<? extends RenderEngine>)InvokerWebApiBinder.this.bindType(RenderEngine.class).uniqueName().to(renderEngineType).toInfo());
        }

        @Override
        public void toProvider(Supplier<? extends RenderEngine> renderEngineProvider) {
            this.bindRender(this.renderName, this.specialMimeType, (BindInfo<? extends RenderEngine>)InvokerWebApiBinder.this.bindType(RenderEngine.class).uniqueName().toProvider(renderEngineProvider).toInfo());
        }

        @Override
        public void bindToInfo(BindInfo<? extends RenderEngine> renderEngineInfo) {
            this.bindRender(this.renderName, this.specialMimeType, Objects.requireNonNull(renderEngineInfo));
        }

        protected abstract void bindRender(String var1, String var2, BindInfo<? extends RenderEngine> var3);
    }

    private class ServletsModuleBuilder
    implements WebApiBinder.ServletBindingBuilder {
        private List<String> uriPatterns;

        ServletsModuleBuilder(List<String> uriPatterns) {
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void with(int index, Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().to(servletKey).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, HttpServlet servlet, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().toInstance((Object)servlet).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, Supplier<? extends HttpServlet> servletProvider, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().toProvider(servletProvider).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
            if (initParams == null) {
                initParams = new HashMap<String, String>();
            }
            for (String pattern : this.uriPatterns) {
                InvokerWebApiBinder.this.jeeServlet(index, pattern, servletRegister, initParams);
            }
            logger.info("mapingTo[Servlet] -> bindID \u2018{}\u2019 mappingTo: \u2018{}\u2019.", (Object)servletRegister.getBindID(), this.uriPatterns);
        }
    }

    private abstract class FiltersModuleBinder<T>
    implements WebApiBinder.FilterBindingBuilder<T> {
        private final Class<T> targetType;
        private final UriPatternType uriPatternType;
        private final List<String> uriPatterns;

        FiltersModuleBinder(Class<T> targetType, UriPatternType uriPatternType, List<String> uriPatterns) {
            this.targetType = targetType;
            this.uriPatternType = uriPatternType;
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void through(int index, Class<? extends T> filterKey, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().to(filterKey).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, T filter, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().toInstance(filter).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, Supplier<? extends T> filterProvider, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().toProvider(filterProvider).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, BindInfo<? extends T> filterRegister, Map<String, String> initParams) {
            if (initParams == null) {
                initParams = new HashMap<String, String>();
            }
            for (String pattern : this.uriPatterns) {
                UriPatternMatcher matcher = UriPatternType.get(this.uriPatternType, pattern);
                this.bindThrough(index, pattern, matcher, filterRegister, initParams);
            }
        }

        protected abstract void bindThrough(int var1, String var2, UriPatternMatcher var3, BindInfo<? extends T> var4, Map<String, String> var5);
    }
}

