/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.ApiBinder;
import net.hasor.core.BindInfo;
import net.hasor.core.aop.AsmTools;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.utils.ArrayUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.web.InvokerFilter;
import net.hasor.web.MappingDiscoverer;
import net.hasor.web.MimeType;
import net.hasor.web.RenderEngine;
import net.hasor.web.ServletVersion;
import net.hasor.web.annotation.MappingTo;
import net.hasor.web.annotation.Render;

public interface WebApiBinder
extends ApiBinder,
MimeType {
    public ServletContext getServletContext();

    public WebApiBinder setRequestCharacter(String var1);

    public WebApiBinder setResponseCharacter(String var1);

    default public WebApiBinder setEncodingCharacter(String requestEncoding, String responseEncoding) {
        return this.setRequestCharacter(requestEncoding).setResponseCharacter(responseEncoding);
    }

    public ServletVersion getServletVersion();

    default public ServletBindingBuilder jeeServlet(String urlPattern, String ... morePatterns) {
        return this.jeeServlet((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public ServletBindingBuilder jeeServlet(String[] var1);

    default public <T> MappingToBindingBuilder<T> mappingTo(String urlPattern, String ... morePatterns) {
        return this.mappingTo((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public <T> MappingToBindingBuilder<T> mappingTo(String[] var1);

    default public void loadMappingTo(Set<Class<?>> mabeMappingToSet) {
        this.loadMappingTo(mabeMappingToSet, aClass -> {
            int modifier = aClass.getModifiers();
            if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || aClass.isArray() || aClass.isEnum()) {
                return false;
            }
            MappingTo[] annotationsByType = (MappingTo[])aClass.getAnnotationsByType(MappingTo.class);
            return annotationsByType != null && annotationsByType.length != 0;
        });
    }

    default public void loadMappingTo(Set<Class<?>> mabeMappingToSet, Predicate<Class<?>> matcher) {
        if (mabeMappingToSet != null && !mabeMappingToSet.isEmpty()) {
            for (Class<?> type : mabeMappingToSet) {
                if (!matcher.test(type)) continue;
                this.loadMappingTo(type);
            }
        }
    }

    default public void loadMappingTo(Class<?> mabeMappingType) {
        Objects.requireNonNull(mabeMappingType, "class is null.");
        int modifier = mabeMappingType.getModifiers();
        if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || mabeMappingType.isArray() || mabeMappingType.isEnum()) {
            throw new IllegalStateException(mabeMappingType.getName() + " must be normal Bean");
        }
        MappingTo[] annotationsByType = (MappingTo[])mabeMappingType.getAnnotationsByType(MappingTo.class);
        if (annotationsByType == null || annotationsByType.length == 0) {
            throw new IllegalStateException(mabeMappingType.getName() + " must be configure @MappingTo");
        }
        if (HttpServlet.class.isAssignableFrom(mabeMappingType)) {
            Arrays.stream(annotationsByType).peek(mappingTo -> {}).forEach(mappingTo -> this.jeeServlet(mappingTo.value()).with(mabeMappingType));
        } else {
            Arrays.stream(annotationsByType).peek(mappingTo -> {}).forEach(mappingTo -> this.mappingTo(mappingTo.value()).with(mabeMappingType));
        }
    }

    default public FilterBindingBuilder<InvokerFilter> filter(String urlPattern, String ... morePatterns) {
        return this.filter((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public FilterBindingBuilder<InvokerFilter> filter(String[] var1);

    default public FilterBindingBuilder<InvokerFilter> filterRegex(String regex, String ... regexes) {
        return this.filter((String[])ArrayUtils.add((Object[])regexes, (Object)regex));
    }

    public FilterBindingBuilder<InvokerFilter> filterRegex(String[] var1);

    default public FilterBindingBuilder<Filter> jeeFilter(String urlPattern, String ... morePatterns) {
        return this.jeeFilter((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public FilterBindingBuilder<Filter> jeeFilter(String[] var1);

    default public FilterBindingBuilder<Filter> jeeFilterRegex(String regex, String ... regexes) {
        return this.jeeFilterRegex((String[])ArrayUtils.add((Object[])regexes, (Object)regex));
    }

    public FilterBindingBuilder<Filter> jeeFilterRegex(String[] var1);

    default public void addServletListener(Class<? extends ServletContextListener> targetKey) {
        BindInfo listenerRegister = this.bindType(ServletContextListener.class).to(targetKey).toInfo();
        this.addServletListener((BindInfo<? extends ServletContextListener>)listenerRegister);
    }

    default public void addServletListener(ServletContextListener sessionListener) {
        BindInfo listenerRegister = this.bindType(ServletContextListener.class).toInstance((Object)sessionListener).toInfo();
        this.addServletListener((BindInfo<? extends ServletContextListener>)listenerRegister);
    }

    default public void addServletListener(Supplier<? extends ServletContextListener> targetProvider) {
        BindInfo listenerRegister = this.bindType(ServletContextListener.class).toProvider(targetProvider).toInfo();
        this.addServletListener((BindInfo<? extends ServletContextListener>)listenerRegister);
    }

    public void addServletListener(BindInfo<? extends ServletContextListener> var1);

    default public void addSessionListener(Class<? extends HttpSessionListener> targetKey) {
        BindInfo listenerRegister = this.bindType(HttpSessionListener.class).to(targetKey).toInfo();
        this.addSessionListener((BindInfo<? extends HttpSessionListener>)listenerRegister);
    }

    default public void addSessionListener(HttpSessionListener sessionListener) {
        BindInfo listenerRegister = this.bindType(HttpSessionListener.class).toInstance((Object)sessionListener).toInfo();
        this.addSessionListener((BindInfo<? extends HttpSessionListener>)listenerRegister);
    }

    default public void addSessionListener(Supplier<? extends HttpSessionListener> targetProvider) {
        BindInfo listenerRegister = this.bindType(HttpSessionListener.class).toProvider(targetProvider).toInfo();
        this.addSessionListener((BindInfo<? extends HttpSessionListener>)listenerRegister);
    }

    public void addSessionListener(BindInfo<? extends HttpSessionListener> var1);

    default public void addDiscoverer(Class<? extends MappingDiscoverer> discoverer) {
        this.addDiscoverer((BindInfo<? extends MappingDiscoverer>)this.bindType(MappingDiscoverer.class).to(Objects.requireNonNull(discoverer)).toInfo());
    }

    default public void addDiscoverer(MappingDiscoverer discoverer) {
        this.addDiscoverer((BindInfo<? extends MappingDiscoverer>)this.bindType(MappingDiscoverer.class).toInstance((Object)Objects.requireNonNull(discoverer)).toInfo());
    }

    default public void addDiscoverer(Supplier<? extends MappingDiscoverer> discoverer) {
        this.addDiscoverer((BindInfo<? extends MappingDiscoverer>)this.bindType(MappingDiscoverer.class).toProvider(Objects.requireNonNull(discoverer)).toInfo());
    }

    public void addDiscoverer(BindInfo<? extends MappingDiscoverer> var1);

    public void addMimeType(String var1, String var2);

    default public void loadMimeType(String resource) throws IOException {
        this.loadMimeType(Charset.forName("UTF-8"), resource);
    }

    default public void loadMimeType(InputStream inputStream) throws IOException {
        this.loadMimeType(Charset.forName("UTF-8"), inputStream);
    }

    default public void loadMimeType(Charset charset, String resource) throws IOException {
        this.loadMimeType(charset, Objects.requireNonNull(ResourcesUtils.getResourceAsStream((String)resource), resource + " is not exist"));
    }

    default public void loadMimeType(Charset charset, InputStream inputStream) throws IOException {
        this.loadMimeType(new InputStreamReader(inputStream, charset));
    }

    public void loadMimeType(Reader var1) throws IOException;

    default public void loadRender(Set<Class<?>> renderSet) {
        this.loadRender(renderSet, aClass -> {
            int modifier = aClass.getModifiers();
            if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || aClass.isArray() || aClass.isEnum()) {
                return false;
            }
            Render[] annotationsByType = (Render[])aClass.getAnnotationsByType(Render.class);
            return annotationsByType != null && annotationsByType.length != 0;
        });
    }

    default public void loadRender(Set<Class<?>> renderSet, Predicate<Class<?>> matcher) {
        if (renderSet != null && !renderSet.isEmpty()) {
            for (Class<?> type : renderSet) {
                if (!matcher.test(type)) continue;
                this.loadRender(type);
            }
        }
    }

    default public void loadRender(Class<?> renderClass) {
        Objects.requireNonNull(renderClass, "class is null.");
        int modifier = renderClass.getModifiers();
        if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || renderClass.isArray() || renderClass.isEnum()) {
            throw new IllegalStateException(renderClass.getName() + " must be normal Bean");
        }
        if (!renderClass.isAnnotationPresent(Render.class)) {
            throw new IllegalStateException(renderClass.getName() + " must be configure @Render");
        }
        if (!RenderEngine.class.isAssignableFrom(renderClass)) {
            throw new IllegalStateException(renderClass.getName() + " must be implements RenderEngine.");
        }
        Render renderInfo = renderClass.getAnnotation(Render.class);
        if (renderInfo != null) {
            this.addRender(renderInfo.name(), renderInfo.specialMimeType()).to(renderClass);
        }
    }

    default public RenderEngineBindingBuilder addRender(String renderName) {
        return this.addRender(renderName, null);
    }

    public RenderEngineBindingBuilder addRender(String var1, String var2);

    public static interface RenderEngineBindingBuilder {
        public <T extends RenderEngine> void to(Class<T> var1);

        default public void toInstance(RenderEngine renderEngine) {
            this.toProvider((Supplier<? extends RenderEngine>)new InstanceProvider((Object)renderEngine));
        }

        public void toProvider(Supplier<? extends RenderEngine> var1);

        public void bindToInfo(BindInfo<? extends RenderEngine> var1);
    }

    public static interface MappingToBindingBuilder<T> {
        default public void with(Class<? extends T> targetKey) {
            this.with(0, (T)targetKey);
        }

        default public void with(T target) {
            this.with(0, target);
        }

        default public void with(Class<T> referKey, Supplier<? extends T> targetProvider) {
            this.with(0, referKey, targetProvider);
        }

        default public void with(BindInfo<? extends T> targetInfo) {
            this.with(0, targetInfo);
        }

        public void with(int var1, Class<? extends T> var2);

        public void with(int var1, T var2);

        public void with(int var1, Class<T> var2, Supplier<? extends T> var3);

        public void with(int var1, BindInfo<? extends T> var2);
    }

    public static interface ServletBindingBuilder {
        default public void with(Class<? extends HttpServlet> targetKey) {
            this.with(0, targetKey, null);
        }

        default public void with(HttpServlet target) {
            this.with(0, target, null);
        }

        default public void with(Supplier<? extends HttpServlet> targetProvider) {
            this.with(0, targetProvider, null);
        }

        default public void with(BindInfo<? extends HttpServlet> targetInfo) {
            this.with(0, targetInfo, null);
        }

        default public void with(Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(0, servletKey, initParams);
        }

        default public void with(HttpServlet servlet, Map<String, String> initParams) {
            this.with(0, servlet, initParams);
        }

        default public void with(Supplier<? extends HttpServlet> servletProvider, Map<String, String> initParams) {
            this.with(0, servletProvider, initParams);
        }

        default public void with(BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
            this.with(0, servletRegister, initParams);
        }

        default public void with(int index, Class<? extends HttpServlet> targetKey) {
            this.with(index, targetKey, null);
        }

        default public void with(int index, HttpServlet target) {
            this.with(index, target, null);
        }

        default public void with(int index, Supplier<? extends HttpServlet> targetProvider) {
            this.with(index, targetProvider, null);
        }

        default public void with(int index, BindInfo<? extends HttpServlet> targetInfo) {
            this.with(index, targetInfo, null);
        }

        public void with(int var1, Class<? extends HttpServlet> var2, Map<String, String> var3);

        public void with(int var1, HttpServlet var2, Map<String, String> var3);

        public void with(int var1, Supplier<? extends HttpServlet> var2, Map<String, String> var3);

        public void with(int var1, BindInfo<? extends HttpServlet> var2, Map<String, String> var3);
    }

    public static interface FilterBindingBuilder<T> {
        default public void through(Class<? extends T> filterKey) {
            this.through(0, (T)filterKey, null);
        }

        default public void through(T filter) {
            this.through(0, filter, null);
        }

        default public void through(Supplier<? extends T> filterProvider) {
            this.through(0, filterProvider, (Map<String, String>)null);
        }

        default public void through(BindInfo<? extends T> filterRegister) {
            this.through(0, filterRegister, (Map<String, String>)null);
        }

        default public void through(Class<? extends T> filterKey, Map<String, String> initParams) {
            this.through(0, (T)filterKey, initParams);
        }

        default public void through(T filter, Map<String, String> initParams) {
            this.through(0, filter, initParams);
        }

        default public void through(Supplier<? extends T> filterProvider, Map<String, String> initParams) {
            this.through(0, filterProvider, initParams);
        }

        default public void through(BindInfo<? extends T> filterRegister, Map<String, String> initParams) {
            this.through(0, filterRegister, initParams);
        }

        default public void through(int index, Class<? extends T> filterKey) {
            this.through(index, (T)filterKey, null);
        }

        default public void through(int index, T filter) {
            this.through(index, filter, null);
        }

        default public void through(int index, Supplier<? extends T> filterProvider) {
            this.through(index, filterProvider, (Map<String, String>)null);
        }

        default public void through(int index, BindInfo<? extends T> filterRegister) {
            this.through(index, filterRegister, (Map<String, String>)null);
        }

        public void through(int var1, Class<? extends T> var2, Map<String, String> var3);

        public void through(int var1, T var2, Map<String, String> var3);

        public void through(int var1, Supplier<? extends T> var2, Map<String, String> var3);

        public void through(int var1, BindInfo<? extends T> var2, Map<String, String> var3);
    }
}

