/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Mapping;
import net.hasor.web.MimeType;

public interface Invoker
extends MimeType {
    public static final String RETURN_DATA_KEY = "resultData";
    public static final String ROOT_DATA_KEY = "rootData";
    public static final String REQUEST_KEY = "request";
    public static final String RESPONSE_KEY = "response";

    public AppContext getAppContext();

    public HttpServletRequest getHttpRequest();

    public HttpServletResponse getHttpResponse();

    public Mapping ownerMapping();

    default public Set<String> keySet() {
        Enumeration names = this.getHttpRequest().getAttributeNames();
        HashSet<String> nameSet = new HashSet<String>();
        while (names.hasMoreElements()) {
            nameSet.add((String)names.nextElement());
        }
        return nameSet;
    }

    default public <T> T fillForm(Class<? extends T> formType) {
        try {
            return (T)this.fillForm(formType, this.getAppContext().justInject(formType.newInstance()));
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    public <T> T fillForm(Class<? extends T> var1, T var2);

    default public Object get(String key) {
        return this.getHttpRequest().getAttribute(key);
    }

    default public void remove(String key) {
        if (StringUtils.isBlank((String)key) || this.isLockKey(key)) {
            throw new UnsupportedOperationException("the key '" + key + "' is lock key.");
        }
        this.getHttpRequest().removeAttribute(key);
    }

    default public void put(String key, Object value) {
        if (StringUtils.isBlank((String)key) || this.isLockKey(key)) {
            throw new UnsupportedOperationException("the key '" + key + "' is lock key.");
        }
        this.getHttpRequest().setAttribute(key, value);
    }

    public boolean isLockKey(String var1);

    public void lockKey(String var1);

    default public String getRequestPath() {
        String contextPath = this.getHttpRequest().getContextPath();
        String requestPath = this.getHttpRequest().getRequestURI();
        if (requestPath.startsWith(contextPath)) {
            requestPath = requestPath.substring(contextPath.length());
        }
        return requestPath;
    }
}

