/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.valid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.valid.Message;
import net.hasor.web.valid.ValidInvoker;
import net.hasor.web.valid.ValidItem;
import net.hasor.web.wrap.InvokerWrap;

public class ValidInvokerSupplier
extends InvokerWrap
implements ValidInvoker {
    private final Map<String, ValidItem> validData = new HashMap<String, ValidItem>();

    protected ValidInvokerSupplier(Invoker context) {
        super(context);
    }

    protected Map<String, ValidItem> getValidData() {
        return this.validData;
    }

    @Override
    public List<String> validKeys() {
        return new ArrayList<String>(this.validData.keySet());
    }

    @Override
    public List<String> validErrors(String key) {
        ValidItem data = this.validData.get(key);
        return data == null ? Collections.EMPTY_LIST : data.stream().map(Message::getMessage).collect(Collectors.toList());
    }

    @Override
    public boolean isValid() {
        for (ValidItem data : this.validData.values()) {
            if (data == null || data.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(String key) {
        ValidItem data = this.validData.get(key);
        return data == null || data.isValid();
    }

    @Override
    public void clearValidErrors() {
        this.validData.clear();
    }

    @Override
    public void clearValidErrors(String key) {
        this.validData.remove(key);
    }

    @Override
    public void addError(String key, Message validMessage) {
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("valid error message key is null.");
        }
        this.errors(new ValidItem(key, validMessage));
    }

    @Override
    public void addErrors(String key, List<Message> validMessage) {
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("valid error message key is null.");
        }
        ValidItem newDate = new ValidItem(key);
        newDate.addAll(validMessage);
        this.errors(newDate);
    }

    protected void errors(ValidItem validItem) {
        if (validItem == null) {
            return;
        }
        ValidItem messages = this.validData.get(validItem.getKey());
        if (messages == null) {
            this.validData.put(validItem.getKey(), validItem);
        } else {
            messages.addAll(validItem);
        }
    }
}

