/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import net.hasor.core.Settings;
import net.hasor.utils.ExceptionUtils;
import net.hasor.web.FileItem;
import net.hasor.web.FileItemFactory;
import net.hasor.web.FileItemHeaders;
import net.hasor.web.FileItemStream;
import net.hasor.web.upload.FileUploadException;
import net.hasor.web.upload.MultipartStream;
import net.hasor.web.upload.ParameterParser;
import net.hasor.web.upload.ServletRequestContext;
import net.hasor.web.upload.util.Closeable;
import net.hasor.web.upload.util.HeadersSet;
import net.hasor.web.upload.util.LimitedInputStream;
import net.hasor.web.upload.util.Streams;

public class FileUpload {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    private static final String POST_METHOD = "POST";
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;
    private String headerEncoding;

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if (!POST_METHOD.equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = new ServletRequestContext(request).getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public FileUpload() {
    }

    public FileUpload(Settings settings) {
        this.setHeaderEncoding("UTF-8");
        this.setSizeMax(settings.getInteger("hasor.restful.fileupload.maxRequestSize", Integer.valueOf(-1)).intValue());
        this.setFileSizeMax(settings.getInteger("hasor.restful.fileupload.maxFileSize", Integer.valueOf(-1)).intValue());
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    public Iterator<FileItemStream> getItemIterator(HttpServletRequest request) throws IOException {
        return new FileItemIteratorImpl(new ServletRequestContext(request));
    }

    public List<FileItem> parseRequest(HttpServletRequest request, FileItemFactory factory) throws IOException {
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        boolean successful = false;
        try {
            Iterator<FileItemStream> fileItems = this.getItemIterator(request);
            if (factory == null) {
                throw new NullPointerException("No FileItemFactory has been set.");
            }
            while (fileItems.hasNext()) {
                FileItemStream itemStream = fileItems.next();
                FileItem fileItem = factory.createItem(itemStream);
                items.add(fileItem);
            }
            successful = true;
            ArrayList<FileItem> arrayList = items;
            return arrayList;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (!successful) {
                for (FileItem fileItem : items) {
                    try {
                        fileItem.deleteOrSkip();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    protected String getFileName(FileItemHeaders headers) {
        return this.getFileName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFileName(String pContentDisposition) {
        String cdl;
        String fileName = null;
        if (pContentDisposition != null && ((cdl = pContentDisposition.toLowerCase(Locale.ENGLISH)).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(pContentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    protected String getFieldName(FileItemHeaders headers) {
        return this.getFieldName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFieldName(String pContentDisposition) {
        String fieldName = null;
        if (pContentDisposition != null && pContentDisposition.toLowerCase(Locale.ENGLISH).startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(pContentDisposition, ';');
            fieldName = params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    protected FileItemHeaders getParsedHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        HeadersSet headers = new HeadersSet();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            StringBuilder header = new StringBuilder(headerPart.substring(start, end));
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header.append(" ").append(headerPart.substring(nonWs, end));
                start = end + 2;
            }
            this.parseHeaderLine(headers, header.toString());
        }
        return headers;
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(HeadersSet headers, String header) {
        int colonOffset = header.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = header.substring(0, colonOffset).trim();
        String headerValue = header.substring(header.indexOf(58) + 1).trim();
        headers.addHeader(headerName, headerValue);
    }

    public class FileItemIteratorImpl
    implements Iterator<FileItemStream> {
        private final MultipartStream multi;
        private final byte[] boundary;
        private FileItemStreamImpl currentItem;
        private String currentFieldName;
        private boolean skipPreamble;
        private boolean itemValid;
        private boolean eof;

        FileItemIteratorImpl(ServletRequestContext ctx) throws IOException {
            String charEncoding;
            if (ctx == null) {
                throw new NullPointerException("ctx parameter");
            }
            String contentType = ctx.getContentType();
            if (null == contentType || !contentType.toLowerCase(Locale.ENGLISH).startsWith(FileUpload.MULTIPART)) {
                String logMEssage = String.format("the request doesn't contain a %s or %s stream, content type header is %s", FileUpload.MULTIPART_FORM_DATA, FileUpload.MULTIPART_MIXED, contentType);
                throw new FileUploadException(FileUploadException.UploadErrorCodes.InvalidContentTypeException, logMEssage);
            }
            InputStream input = ctx.getInputStream();
            long requestSize = ctx.contentLength();
            if (FileUpload.this.sizeMax >= 0L) {
                if (requestSize != -1L && requestSize > FileUpload.this.sizeMax) {
                    String logMEssage = String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", requestSize, FileUpload.this.sizeMax);
                    throw new FileUploadException(FileUploadException.UploadErrorCodes.SizeLimitExceededException, logMEssage);
                }
                input = new LimitedInputStream(input, FileUpload.this.sizeMax){

                    @Override
                    protected void raiseError(long pSizeMax, long pCount) throws IOException {
                        String logMEssage = String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", pCount, pSizeMax);
                        throw new FileUploadException(FileUploadException.UploadErrorCodes.SizeLimitExceededException, logMEssage);
                    }
                };
            }
            if ((charEncoding = FileUpload.this.headerEncoding) == null) {
                charEncoding = ctx.getCharacterEncoding();
            }
            this.boundary = FileUpload.this.getBoundary(contentType);
            if (this.boundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            try {
                this.multi = new MultipartStream(input, this.boundary);
            }
            catch (IllegalArgumentException iae) {
                String logMessage = String.format("The boundary specified in the %s header is too long", FileUpload.CONTENT_TYPE);
                throw new FileUploadException(FileUploadException.UploadErrorCodes.InvalidContentTypeException, logMessage);
            }
            this.multi.setHeaderEncoding(charEncoding);
            this.skipPreamble = true;
            this.findNextItem();
        }

        private boolean findNextItem() throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.currentItem != null) {
                this.currentItem.close();
                this.currentItem = null;
            }
            while (true) {
                boolean nextPart;
                if (!(nextPart = this.skipPreamble ? this.multi.skipPreamble() : this.multi.readBoundary())) {
                    if (this.currentFieldName == null) {
                        this.eof = true;
                        return false;
                    }
                    this.multi.setBoundary(this.boundary);
                    this.currentFieldName = null;
                    continue;
                }
                FileItemHeaders headers = FileUpload.this.getParsedHeaders(this.multi.readHeaders());
                if (this.currentFieldName == null) {
                    String fieldName = FileUpload.this.getFieldName(headers);
                    if (fieldName != null) {
                        String fileName;
                        String subContentType = headers.getHeader(FileUpload.CONTENT_TYPE);
                        if (subContentType != null && subContentType.toLowerCase(Locale.ENGLISH).startsWith(FileUpload.MULTIPART_MIXED)) {
                            this.currentFieldName = fieldName;
                            byte[] subBoundary = FileUpload.this.getBoundary(subContentType);
                            this.multi.setBoundary(subBoundary);
                            this.skipPreamble = true;
                            continue;
                        }
                        this.currentItem = new FileItemStreamImpl(headers, fileName, fieldName, (fileName = FileUpload.this.getFileName(headers)) == null, this.getContentLength(headers));
                        this.itemValid = true;
                        return true;
                    }
                } else {
                    String fileName = FileUpload.this.getFileName(headers);
                    if (fileName != null) {
                        this.currentItem = new FileItemStreamImpl(headers, fileName, this.currentFieldName, false, this.getContentLength(headers));
                        this.itemValid = true;
                        return true;
                    }
                }
                this.multi.discardBodyData();
            }
        }

        private long getContentLength(FileItemHeaders pHeaders) {
            try {
                return Long.parseLong(pHeaders.getHeader(FileUpload.CONTENT_LENGTH));
            }
            catch (Exception e) {
                return -1L;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.itemValid) {
                return true;
            }
            try {
                return this.findNextItem();
            }
            catch (IOException e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        }

        @Override
        public FileItemStream next() {
            if (this.eof || !this.itemValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.itemValid = false;
            return this.currentItem;
        }

        class FileItemStreamImpl
        implements FileItemStream {
            private final String contentType;
            private final String fieldName;
            private final String name;
            private final boolean formField;
            private final InputStream stream;
            private boolean opened;
            private FileItemHeaders headers;

            FileItemStreamImpl(FileItemHeaders headers, String pName, String pFieldName, boolean pFormField, long pContentLength) throws IOException {
                MultipartStream.ItemInputStream itemStream;
                this.headers = headers;
                this.name = pName;
                this.fieldName = pFieldName;
                this.contentType = headers.getHeader(FileUpload.CONTENT_TYPE);
                this.formField = pFormField;
                InputStream istream = itemStream = FileItemIteratorImpl.this.multi.newInputStream();
                if (FileUpload.this.fileSizeMax != -1L) {
                    if (pContentLength != -1L && pContentLength > FileUpload.this.fileSizeMax) {
                        String logMessage = String.format("The field %s exceeds its maximum permitted size of %s bytes.", this.fieldName, FileUpload.this.fileSizeMax);
                        throw new FileUploadException(FileUploadException.UploadErrorCodes.FileSizeLimitExceededException, logMessage);
                    }
                    istream = new LimitedInputStream(istream, FileUpload.this.fileSizeMax){

                        @Override
                        protected void raiseError(long pSizeMax, long pCount) throws IOException {
                            itemStream.close(true);
                            String logMessage = String.format("The field %s exceeds its maximum permitted size of %s bytes.", FileItemStreamImpl.this.fieldName, pSizeMax);
                            throw new FileUploadException(FileUploadException.UploadErrorCodes.FileSizeLimitExceededException, logMessage);
                        }
                    };
                }
                this.stream = istream;
            }

            @Override
            public String getContentType() {
                return this.contentType;
            }

            @Override
            public String getFieldName() {
                return this.fieldName;
            }

            @Override
            public String getName() {
                return Streams.checkFileName(this.name);
            }

            @Override
            public boolean isFormField() {
                return this.formField;
            }

            @Override
            public InputStream openStream() throws IOException {
                if (this.opened) {
                    throw new IllegalStateException("The stream was already opened.");
                }
                if (((Closeable)((Object)this.stream)).isClosed()) {
                    throw new FileUploadException(FileUploadException.UploadErrorCodes.ItemSkippedException);
                }
                return this.stream;
            }

            void close() throws IOException {
                this.stream.close();
            }

            @Override
            public FileItemHeaders getHeaders() {
                return this.headers;
            }
        }
    }
}

