/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.Mapping;
import net.hasor.web.MimeType;
import net.hasor.web.invoker.InvokerCallerParamsBuilder;

public class InvokerSupplier
implements Invoker {
    private Set<String> lockKeys = new HashSet<String>();
    private HttpServletRequest httpRequest = null;
    private HttpServletResponse httpResponse = null;
    private AppContext appContext = null;
    private MimeType mimeType = null;
    private Mapping ownerInMapping = null;

    protected InvokerSupplier(Mapping ownerInMapping, AppContext appContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.ownerInMapping = ownerInMapping;
        this.appContext = appContext;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.mimeType = (MimeType)appContext.getInstance(MimeType.class);
        this.put("rootData", this);
        this.put("request", this.httpRequest);
        this.put("response", this.httpResponse);
        this.lockKey("rootData");
        this.lockKey("request");
        this.lockKey("response");
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }

    @Override
    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public Mapping ownerMapping() {
        return this.ownerInMapping;
    }

    @Override
    public boolean isLockKey(String key) {
        return this.lockKeys.contains(key);
    }

    @Override
    public void lockKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        this.lockKeys.add(key);
    }

    @Override
    public String getMimeType(String suffix) {
        return this.mimeType.getMimeType(suffix);
    }

    @Override
    public <T> T fillForm(Class<? extends T> formType, T bean) {
        return new InvokerCallerParamsBuilder().getParamsParam(this, formType, bean);
    }
}

