/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.definition;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import net.hasor.core.AppContext;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerFilter;
import net.hasor.web.definition.UriPatternMatcher;
import net.hasor.web.definition.UriPatternType;

public abstract class AbstractDefinition
implements InvokerFilter {
    private final int index;
    private final Map<String, String> initParams;
    private final String pattern;
    private final UriPatternMatcher patternMatcher;
    private AppContext appContext = null;

    public AbstractDefinition(int index, String pattern, UriPatternMatcher patternMatcher, Map<String, String> initParams) {
        this.index = index;
        this.initParams = initParams != null ? new HashMap<String, String>(initParams) : new HashMap<String, String>();
        this.pattern = pattern;
        this.patternMatcher = patternMatcher;
    }

    public int getIndex() {
        return this.index;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public String getPattern() {
        return this.pattern;
    }

    public UriPatternType getUriPatternType() {
        return this.patternMatcher.getPatternType();
    }

    public boolean matchesInvoker(Invoker invoker) {
        String url = invoker.getRequestPath();
        return this.patternMatcher.matches(url);
    }

    public String toString() {
        return String.format("pattern=%s ,uriPatternType=%s ,type %s ,initParams=%s ", new Object[]{this.getPattern(), this.getUriPatternType(), this.getClass(), this.getInitParams()});
    }

    @Override
    public final void init(InvokerConfig config) throws Throwable {
        this.appContext = config.getAppContext();
        Enumeration<String> names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            String key = names.nextElement();
            String value = config.getInitParameter(key);
            this.getInitParams().put(key, value);
        }
        this.getTarget();
    }

    protected AppContext getAppContext() {
        return this.appContext;
    }

    protected abstract Object getTarget() throws Throwable;
}

