/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.valid;

import java.util.Arrays;
import java.util.List;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.valid.Message;
import net.hasor.web.valid.ValidBy;
import net.hasor.web.valid.Validation;

public interface ValidInvoker
extends Invoker {
    public static final String VALID_DATA_KEY = "validData";

    public List<String> validKeys();

    public List<String> validErrors(String var1);

    public boolean isValid();

    public boolean isValid(String var1);

    public void clearValidErrors();

    public void clearValidErrors(String var1);

    default public void addError(String key, String validString) {
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("valid error message key is null.");
        }
        this.addError(key, new Message(validString));
    }

    default public void addError(String key, String validString, Object ... args) {
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("valid error message key is null.");
        }
        this.addError(key, new Message(validString, args));
    }

    public void addError(String var1, Message var2);

    public void addErrors(String var1, List<Message> var2);

    default public void doValid(String scene, Object object) {
        if (object == null) {
            return;
        }
        this.doValid(scene, object, object.getClass());
    }

    default public void doValid(String scene, Object object, Class<?> oriType) {
        ValidBy[] byType = (ValidBy[])oriType.getAnnotationsByType(ValidBy.class);
        if (byType == null || byType.length == 0) {
            return;
        }
        Class[] collect = (Class[])Arrays.stream(byType).flatMap(validBy -> Arrays.stream(validBy.value())).toArray(Class[]::new);
        this.doValid(scene, object, collect);
    }

    default public void doValid(String scene, Object object, Class<? extends Validation> ... validArrays) {
        for (Class<? extends Validation> validType : validArrays) {
            Validation validation = (Validation)this.getAppContext().getInstance(validType);
            if (validation == null) {
                throw new NullPointerException("create " + validType.getName() + " Validation failed , return null.");
            }
            validation.doValidation(scene, object, this);
        }
    }
}

